/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.RowValueListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class RowValue
implements Serializable {
    private List<Object> cellValues;
    private List<RowValueListener> listeners;

    public RowValue(Object ... cellValues) {
        if (cellValues == null) {
            throw new IllegalArgumentException("O par\u00e2metro cellValues est\u00e1 nulo.\n");
        }
        this.cellValues = new ArrayList<Object>(cellValues.length);
        Object[] objectArray = cellValues;
        int n = cellValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object cellValue = objectArray[n2];
            this.cellValues.add(cellValue);
            ++n2;
        }
        this.listeners = new LinkedList<RowValueListener>();
    }

    public void addRowValueListener(RowValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public Object getCellValue(int columnIndex) {
        return this.cellValues.get(columnIndex);
    }

    public boolean removeRowValueListener(RowValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    public void setCellValue(Object cellValue, int columnIndex) {
        this.cellValues.set(columnIndex, cellValue);
        for (RowValueListener listener : this.listeners) {
            listener.valueWasChanged(cellValue, columnIndex);
        }
    }

    public List<Object> getCellValues() {
        return Collections.unmodifiableList(this.cellValues);
    }
}

