/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TableExpressionFunction
extends ExpressionFunction {
    public TableExpressionFunction(String name, Class<?> ... parameterTypes) {
        super(name, TableExpressionFunction.createParameterTypes(parameterTypes));
    }

    protected abstract Object doOperation(List<Object> var1, Object ... var2) throws ExpressionFunctionExecutionException;

    @Override
    protected final Object doOperation(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameters est\u00e1 nulo.");
        }
        if (parameters.length < 2) {
            throw new ExpressionFunctionExecutionException("Esta fun\u00e7\u00e3o trabalha sobre tabelas.\nO primeiro par\u00e2metro tem que ser uma tabela e o segundo par\u00e2metro tem que ser uma coluna.\nPrimeiro forne\u00e7a o nome da lista a ser utilizada.\nFun\u00e7\u00e3o: {0}.", this, parameters.length);
        }
        if (!(parameters[0] instanceof String)) {
            throw new ExpressionFunctionExecutionException("Esta fun\u00e7\u00e3o trabalha sobre tabelas.\nO primeiro valor tem que ser uma tabela, por\u00e9m foi informado um valor que n\u00e3o \u00e9 um nome de tabela.\nForne\u00e7a o nome da tabela a ser utilizada.\nFun\u00e7\u00e3o: {0}.\nValor: {1}.", this, parameters[0]);
        }
        String parameterName = (String)parameters[0];
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ExpressionFunctionExecutionException("A tabela {0} n\u00e3o foi encontrada no configurador {1}.\nFun\u00e7\u00e3o: {2}.", parameterName, configurator, this);
        }
        if (!(parameter instanceof TableParameter)) {
            throw new ExpressionFunctionExecutionException("O par\u00e2metro {0} do configurador {1} n\u00e3o \u00e9 uma tabela.\nFun\u00e7\u00e3o: {2}.", parameterName, configurator, this);
        }
        TableParameter tableParameter = (TableParameter)parameter;
        if (!(parameters[1] instanceof Double)) {
            throw new ExpressionFunctionExecutionException("Esta fun\u00e7\u00e3o trabalha sobre tabelas.\nO segundo valor tem que ser uma coluna, por\u00e9m foi informado um valor que n\u00e3o \u00e9 um \u00edndice de coluna.\nForne\u00e7a o nome da coluna a ser utilizada.\nFun\u00e7\u00e3o: {0}.\nValor: {1}.", this, parameters[1]);
        }
        int columnIndex = ((Double)parameters[1]).intValue();
        if (columnIndex >= tableParameter.getColumnCount()) {
            throw new ExpressionFunctionExecutionException("A coluna {1} da tabela {0} n\u00e3o foi encontrada no configurador {2}.\nFun\u00e7\u00e3o: {3}.", parameterName, columnIndex, configurator, this);
        }
        List<Object> values = new ArrayList(tableParameter.getRowCount());
        int i = 0;
        while (i < tableParameter.getRowCount()) {
            Object value = tableParameter.getItemValue(i, columnIndex);
            values.add(value);
            ++i;
        }
        values = Collections.unmodifiableList(values);
        Object[] newParameters = new Object[parameters.length - 2];
        int i2 = 0;
        while (i2 < newParameters.length) {
            newParameters[i2] = parameters[i2 + 2];
            ++i2;
        }
        return this.doOperation(values, newParameters);
    }

    private static Class<?>[] createParameterTypes(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterTypes est\u00e1 nulo.");
        }
        Class[] newParameterTypes = new Class[parameterTypes.length + 2];
        newParameterTypes[0] = String.class;
        newParameterTypes[1] = Double.class;
        int i = 2;
        while (i < newParameterTypes.length) {
            newParameterTypes[i] = parameterTypes[i - 2];
            ++i;
        }
        return newParameterTypes;
    }
}

