/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.RowValueListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameterListener;
import csbase.logic.algorithms.parameters.TableParameterParser;
import csbase.logic.algorithms.parameters.validators.TableParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.openbus.algorithmservice.v1_0.parameters.TableParameterHelper;

public final class TableParameter
extends SimpleParameter<List<RowValue>>
implements RowValueListener {
    private List<Column<?>> columns;
    private boolean delimitRows;
    private boolean delimitTable;
    private Integer fixedRowCount;
    private transient List<TableParameterListener> listeners;
    private List<RowValue> rowValues;
    private Integer visibleRowCount;
    private Integer maxRowCount;
    private Integer minRowCount;

    public TableParameter(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, List<? extends Column<?>> columns, boolean delimitTable, boolean delimitRows, Integer fixedRowCount, Integer visibleRowCount, Integer minRowCount, Integer maxRowCount) {
        super(name, label, description, null, isOptional, isVisible, commandLinePattern);
        this.setColumns(columns);
        this.testIfPositive(visibleRowCount, "N\u00famero de linha vis\u00edveis");
        this.testIfPositive(fixedRowCount, "N\u00famero de linhas (fixo)");
        this.testIfPositive(maxRowCount, "N\u00famero m\u00e1ximo de linhas");
        this.testIfPositive(minRowCount, "N\u00famero m\u00ednimo de linhas (fixo)");
        if (maxRowCount != null && minRowCount != null && maxRowCount < minRowCount) {
            String fmt = "Valores inconsistentes de min/max de linhas (%d e %d)";
            String err = String.format("Valores inconsistentes de min/max de linhas (%d e %d)", minRowCount, maxRowCount);
            throw new IllegalArgumentException(err);
        }
        this.visibleRowCount = visibleRowCount;
        this.fixedRowCount = fixedRowCount;
        this.maxRowCount = maxRowCount;
        this.minRowCount = minRowCount;
        this.delimitTable = delimitTable;
        this.delimitRows = delimitRows;
        this.listeners = new LinkedList<TableParameterListener>();
        this.rowValues = new ArrayList<RowValue>();
        this.setValue(this.rowValues);
        this.createDefaultRows();
    }

    private void testIfPositive(Integer value, String name) {
        if (value != null && value <= 0) {
            String fmt = "%s n\u00e3o positivo. Valor = %d";
            String err = String.format("%s n\u00e3o positivo. Valor = %d", name, value);
            throw new IllegalArgumentException(err);
        }
    }

    public void addTableParameterListener(TableParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public void addRow(RowValue rowValue) {
        if (rowValue == null) {
            throw new IllegalArgumentException("O par\u00e2metro rowValue est\u00e1 nulo.");
        }
        rowValue.addRowValueListener(this);
        int rowIndex = this.rowValues.size();
        this.rowValues.add(rowValue);
        this.fireRowWasCreated(rowValue, rowIndex);
        this.fireValueWasChangedEvent();
    }

    public void createRow() {
        int rowIndex = this.rowValues.size();
        Object[] row = new Object[this.getColumnCount()];
        int columnIndex = 0;
        while (columnIndex < this.getColumnCount()) {
            Column<?> column = this.columns.get(columnIndex);
            row[columnIndex] = column.getDefaultValue(rowIndex);
            ++columnIndex;
        }
        RowValue rowValue = new RowValue(row);
        this.addRow(rowValue);
    }

    public boolean hasFixedRowCount() {
        return this.fixedRowCount != null;
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            String message = MessageFormat.format("O \u00edndice da linha fornecido - {0} - fora da faixa suportada (0 a {1}).", new Integer(rowIndex), new Integer(this.getRowCount()));
            throw new IllegalArgumentException(message);
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        rowValue.removeRowValueListener(this);
        this.rowValues.remove(rowIndex);
        this.fireRowWasRemoved(rowValue, rowIndex);
        this.fireValueWasChangedEvent();
    }

    public boolean delimitRows() {
        return this.delimitRows;
    }

    public boolean delimitTable() {
        return this.delimitTable;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Integer getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Integer getMaxRowCount() {
        return this.maxRowCount;
    }

    public Integer getMinRowCount() {
        return this.minRowCount;
    }

    public List<Column<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public String getCommandValue(CommandLineContext context) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.getColumnCount() == 0) {
            return null;
        }
        String commandValue = "";
        if (this.delimitTable()) {
            commandValue = String.valueOf(commandValue) + "{";
        }
        String rowSeparator = "";
        int i = 0;
        while (i < this.getRowCount()) {
            commandValue = String.valueOf(commandValue) + rowSeparator;
            if (this.delimitRows()) {
                commandValue = String.valueOf(commandValue) + "{";
            }
            String cellSeparator = "";
            int j = 0;
            while (j < this.columns.size()) {
                commandValue = String.valueOf(commandValue) + cellSeparator;
                Object itemValue = this.getItemValue(i, j);
                Column<?> column = this.columns.get(j);
                String itemCommandValue = column.getCommandValue(itemValue);
                commandValue = String.valueOf(commandValue) + itemCommandValue;
                cellSeparator = ",";
                ++j;
            }
            if (this.delimitRows()) {
                commandValue = String.valueOf(commandValue) + "}";
            }
            rowSeparator = ",";
            ++i;
        }
        if (this.delimitTable()) {
            commandValue = String.valueOf(commandValue) + "}";
        }
        return commandValue;
    }

    @Override
    public Object getExpressionValue() {
        return this.getName();
    }

    public Object getItemValue(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            String message = MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel obter o valor da c\u00e9lula ({0};{1}), pois a tabela n\u00e3o possui linhas.", new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (this.getColumnCount() == 0) {
            String message = MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel obter o valor da c\u00e9lula ({0};{1}), pois a tabela n\u00e3o possui colunas.", new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro rowIndex est\u00e1 fora da faixa esperada.\nFaixa esperada: 0 a {0}.\n\u00cdndice da linha (rowIndex): {1}.", new Integer(this.getRowCount()), new Integer(rowIndex)));
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro columnIndex est\u00e1 fora da faixa esperada.\nFaixa esperada: 0 a {0}.\n\u00cdndice da coluna (columnIndex): {1}.", new Integer(this.getColumnCount()), new Integer(columnIndex)));
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        return rowValue.getCellValue(columnIndex);
    }

    public int getRowCount() {
        return this.rowValues.size();
    }

    public List<RowValue> getRowValues() {
        return Collections.unmodifiableList(this.rowValues);
    }

    public List<TableParameterListener> getTableParameterListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public String getType() {
        return "TABLE";
    }

    @Override
    public String getIDLType() {
        return TableParameterHelper.id();
    }

    @Override
    public String getValueAsText() {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.getColumnCount() == 0) {
            return null;
        }
        String text = "";
        text = String.valueOf(text) + '{';
        String rowSeparator = "";
        int i = 0;
        while (i < this.getRowCount()) {
            text = String.valueOf(text) + rowSeparator;
            text = String.valueOf(text) + '{';
            String cellSeparator = "";
            int j = 0;
            while (j < this.columns.size()) {
                Object itemValue = this.getItemValue(i, j);
                Column<?> column = this.columns.get(j);
                String itemText = column.getItemValueAsText(itemValue);
                if (itemText == null) {
                    itemText = "";
                }
                text = String.valueOf(text) + cellSeparator;
                text = String.valueOf(text) + itemText;
                cellSeparator = Character.toString(',');
                ++j;
            }
            text = String.valueOf(text) + '}';
            rowSeparator = Character.toString(',');
            ++i;
        }
        text = String.valueOf(text) + '}';
        return text;
    }

    @Override
    public Map<String, Object> exportValue() {
        ArrayList<Object[]> newRowValues = new ArrayList<Object[]>(this.getRowCount());
        int i = 0;
        while (i < this.rowValues.size()) {
            RowValue rowValue = this.rowValues.get(i);
            List<Object> cellValueList = rowValue.getCellValues();
            Object[] cellValues = new Object[cellValueList.size()];
            int j = 0;
            while (j < cellValues.length) {
                Column<?> column = this.columns.get(j);
                Object cellValue = cellValueList.get(j);
                cellValues[j] = column.getValueToExport(cellValue);
                ++j;
            }
            newRowValues.add(cellValues);
            ++i;
        }
        HashMap<String, ArrayList<Object[]>> parameterValue = new HashMap<String, ArrayList<Object[]>>();
        parameterValue.put(this.getName(), newRowValues);
        return Collections.unmodifiableMap(parameterValue);
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        if (parameterValues == null) {
            String err = "O par\u00e2metro parameterValues est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro parameterValues est\u00e1 nulo.");
        }
        this.clearRows();
        List values = (List)parameterValues.get(this.getName());
        if (values != null) {
            int i = 0;
            while (i < values.size()) {
                this.createRow();
                ++i;
            }
            i = 0;
            while (i < values.size()) {
                Object[] cellValues = (Object[])values.get(i);
                int j = 0;
                while (j < cellValues.length) {
                    Column<?> column = this.columns.get(j);
                    this.setItemValue(column.getValueToImport(cellValues[j]), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void resetValue() {
        this.clearRows();
        this.createDefaultRows();
    }

    public boolean setItemValue(Object value, int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            String message = MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel atribuir o valor {0} \u00e0 c\u00e9lula ({1};{2}), pois a tabela n\u00e3o possui linhas.", value, new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (this.getColumnCount() == 0) {
            String message = MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel atribuir o valor {0} \u00e0 c\u00e9lula ({1};{2}), pois a tabela n\u00e3o possui colunas.", value, new Integer(rowIndex), new Integer(columnIndex));
            throw new IllegalArgumentException(message);
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro rowIndex est\u00e1 fora da faixa esperada.\nFaixa esperada: 0 a {0}.\n\u00cdndice da linha (rowIndex): {1}.", new Integer(this.getRowCount()), new Integer(rowIndex)));
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro columnIndex est\u00e1 fora da faixa esperada.\nFaixa esperada: 0 a {0}.\n\u00cdndice da coluna (columnIndex): {1}.", new Integer(this.getColumnCount()), new Integer(columnIndex)));
        }
        RowValue rowValue = this.rowValues.get(rowIndex);
        Object oldValue = rowValue.getCellValue(columnIndex);
        if (oldValue == null && value == null) {
            return false;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return false;
        }
        rowValue.setCellValue(value, columnIndex);
        return true;
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue != null) {
            List<List<String>> table;
            TableParameterParser parser = new TableParameterParser();
            try {
                table = parser.parseText(parameterValue);
            }
            catch (AutomatonException e) {
                throw new ParseException("N\u00e3o \u00e9 possivel atribuir o valor\n({0}),j\u00e1 que ele n\u00e3o representa uma codifica\u00e7\u00e3o v\u00e1lida para tabelas.\nPar\u00e2metro envolvido: {1}.", parameterValue, this);
            }
            int i = 0;
            while (i < table.size()) {
                List<String> row = table.get(i);
                if (row.size() != this.getColumnCount()) {
                    throw new ParseException("N\u00e3o \u00e9 possivel atribuir o valor\n({0}),j\u00e1 que ele representa uma tabela com {2} colunas, por\u00e9m esta tabela {1} possui {3} colunas.\nPar\u00e2metro envolvido: {1}.", parameterValue, this, new Integer(row.size()), new Integer(this.getColumnCount()));
                }
                ++i;
            }
            Object[][] newValues = new Object[table.size()][this.getColumnCount()];
            int i2 = 0;
            while (i2 < table.size()) {
                List<String> row = table.get(i2);
                int j = 0;
                while (j < row.size()) {
                    Column<?> column = this.getColumns().get(j);
                    String itemValueAsText = row.get(j);
                    Object itemValue = column.getItemValueFromText(itemValueAsText);
                    newValues[i2][j] = itemValue;
                    ++j;
                }
                ++i2;
            }
            this.clearRows();
            i2 = 0;
            while (i2 < newValues.length) {
                this.createRow();
                ++i2;
            }
            i2 = 0;
            while (i2 < newValues.length) {
                int j = 0;
                while (j < newValues[i2].length) {
                    Object itemValue = newValues[i2][j];
                    this.setItemValue(itemValue, i2, j);
                    ++j;
                }
                ++i2;
            }
        } else {
            this.clearRows();
        }
    }

    @Override
    public void valueWasChanged(Object newValue, int columnIndex) {
        this.fireValueWasChangedEvent();
    }

    private void createDefaultRows() {
        if (this.fixedRowCount != null) {
            int rowIndex = 0;
            while (rowIndex < this.fixedRowCount) {
                this.createRow();
                ++rowIndex;
            }
        }
    }

    private void clearRows() {
        if (this.getRowCount() != 0) {
            do {
                this.removeRow(this.getRowCount() - 1);
            } while (this.getRowCount() != 0);
            this.fireValueWasChangedEvent();
        }
    }

    private void setColumns(List<? extends Column<?>> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("O par\u00e2metro columns est\u00e1 nulo.");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("O par\u00e2metro columns est\u00e1 vazio.");
        }
        this.columns = new ArrayList(columns);
    }

    private void fireRowWasCreated(RowValue rowValue, int rowIndex) {
        for (TableParameterListener listener : this.listeners) {
            listener.rowWasCreated(this, rowValue, rowIndex);
        }
    }

    private void fireRowWasRemoved(RowValue rowValue, int rowIndex) {
        for (TableParameterListener listener : this.listeners) {
            listener.rowWasRemoved(this, rowValue, rowIndex);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<TableParameterListener>();
    }

    public TableParameterValidator createParameterValidator() {
        return new TableParameterValidator(this.isOptional(), this.getColumns());
    }
}

