/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.parsers.FiniteAutomaton;
import tecgraf.javautils.parsers.Parser;
import tecgraf.javautils.parsers.State;
import tecgraf.javautils.parsers.Token;
import tecgraf.javautils.parsers.actions.AppendAction;
import tecgraf.javautils.parsers.actions.CompositeTransitionAction;
import tecgraf.javautils.parsers.actions.DiscardAction;
import tecgraf.javautils.parsers.actions.GenerateTokenAction;
import tecgraf.javautils.parsers.actions.TransitionAction;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.iterators.CharSymbolIterator;
import tecgraf.javautils.parsers.iterators.SymbolIterator;
import tecgraf.javautils.parsers.symbols.CharSymbol;
import tecgraf.javautils.parsers.symbols.Symbol;

final class TableParameterParser
extends Parser {
    static final char START_CHARACTER = '{';
    static final char END_CHARACTER = '}';
    static final char SEPARATOR_CHARACTER = ',';
    private RowParameterParser elementGeneratorParser = new RowParameterParser();

    TableParameterParser() {
        super((FiniteAutomaton)new TableParameterFiniteAutomaton());
    }

    List<List<String>> parseText(Reader reader) throws AutomatonException, IOException {
        int current;
        StringBuilder buffer = new StringBuilder();
        while ((current = reader.read()) != -1) {
            buffer.append((char)current);
        }
        String text = buffer.toString();
        return this.parseText(text);
    }

    List<List<String>> parseText(String text) throws AutomatonException {
        LinkedList<List<String>> rows = new LinkedList<List<String>>();
        List tokens = this.parse((SymbolIterator)new CharSymbolIterator(text));
        for (Token token : tokens) {
            StringBuffer buffer = new StringBuffer();
            List symbols = token.getSymbolList();
            for (Symbol symbol : symbols) {
                buffer.append(symbol.getObject());
            }
            List<String> row = this.elementGeneratorParser.parseText(buffer.toString());
            rows.add(row);
        }
        return rows;
    }

    private static final class RowParameterParser
    extends Parser {
        RowParameterParser() {
            super((FiniteAutomaton)new RowFiniteAutomaton());
        }

        List<String> parseText(String text) throws AutomatonException {
            List tokens = this.parse((SymbolIterator)new CharSymbolIterator(text));
            ArrayList<String> row = new ArrayList<String>(tokens.size());
            for (Token token : tokens) {
                StringBuffer buffer = new StringBuffer();
                List symbols = token.getSymbolList();
                for (Symbol symbol : symbols) {
                    Character object = (Character)symbol.getObject();
                    buffer.append(object);
                }
                String cellValue = buffer.length() != 0 ? buffer.toString() : null;
                row.add(cellValue);
            }
            return row;
        }

        private static final class RowFiniteAutomaton
        extends FiniteAutomaton {
            private static final CharSymbol START_SYMBOL = new CharSymbol('{');
            private static final CharSymbol SEPARATOR_SYMBOL = new CharSymbol(',');
            private static final CharSymbol END_SYMBOL = new CharSymbol('}');

            RowFiniteAutomaton() {
                super(new State(false));
                State startLineState = this.getInitialState();
                State elementState = new State(false);
                State endLineState = new State(true);
                startLineState.addTransition((Symbol)START_SYMBOL, (TransitionAction)DiscardAction.getInstance(), elementState);
                elementState.addTransition((Symbol)SEPARATOR_SYMBOL, (TransitionAction)GenerateTokenAction.getInstance(), elementState);
                elementState.addTransition((Symbol)END_SYMBOL, (TransitionAction)new CompositeTransitionAction(new TransitionAction[]{GenerateTokenAction.getInstance(), DiscardAction.getInstance()}), endLineState);
                elementState.setDefaultTransition((TransitionAction)AppendAction.getInstance(), elementState);
            }
        }
    }

    private static final class TableParameterFiniteAutomaton
    extends FiniteAutomaton {
        private static final CharSymbol START_SYMBOL = new CharSymbol('{');
        private static final CharSymbol SEPARATOR_SYMBOL = new CharSymbol(',');
        private static final CharSymbol END_SYMBOL = new CharSymbol('}');

        private TableParameterFiniteAutomaton() {
            super(new State(false));
            State startTable = this.getInitialState();
            State startLine = new State(false);
            State buildingElement = new State(false);
            State endLine = new State(false);
            State endTable = new State(true);
            startTable.addTransition((Symbol)START_SYMBOL, (TransitionAction)DiscardAction.getInstance(), startLine);
            startLine.addTransition((Symbol)START_SYMBOL, (TransitionAction)AppendAction.getInstance(), buildingElement);
            startLine.addTransition((Symbol)END_SYMBOL, (TransitionAction)DiscardAction.getInstance(), endTable);
            buildingElement.setDefaultTransition((TransitionAction)AppendAction.getInstance(), buildingElement);
            CompositeTransitionAction compositeAction = new CompositeTransitionAction();
            compositeAction.addAction((TransitionAction)AppendAction.getInstance());
            compositeAction.addAction((TransitionAction)GenerateTokenAction.getInstance());
            buildingElement.addTransition((Symbol)END_SYMBOL, (TransitionAction)compositeAction, endLine);
            endLine.addTransition((Symbol)SEPARATOR_SYMBOL, (TransitionAction)DiscardAction.getInstance(), startLine);
            endLine.addTransition((Symbol)END_SYMBOL, (TransitionAction)DiscardAction.getInstance(), endTable);
        }
    }
}

