/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.URLListParameterValidator;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class URLListParameter
extends ListParameter<URLValue> {
    private static String PATH = ".path";
    private static String TYPE = ".type";
    private static final String PROTOCOL = ".protocol";
    private static final String HOST = ".host";
    private String localization;
    protected String fileType;
    private FileParameterMode mode;
    private final boolean mustExist;
    private EnumSet<URLProtocol> allowedProtocols;

    public URLListParameter(String name, String label, String description, List<URLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String fileType, FileParameterMode mode, boolean mustSort, boolean mustExist, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, mustSort, false, commandLinePattern);
        this.localization = localization;
        this.fileType = fileType;
        this.mustExist = mustExist;
        this.allowedProtocols = allowedProtocols;
        this.setMode(mode);
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap valuesByName = new HashMap();
        LinkedList exportableValues = new LinkedList();
        List urls = (List)this.getValue();
        if (urls != null) {
            for (URLValue url : urls) {
                HashMap<String, String> exportableValue = new HashMap<String, String>();
                exportableValue.put(PATH, url.getPath());
                exportableValue.put(TYPE, url.getType());
                URLProtocol protocol = url.getProtocol();
                if (protocol != null) {
                    exportableValue.put(PROTOCOL, protocol.getType());
                }
                exportableValue.put(HOST, url.getHost());
                exportableValues.add(Collections.unmodifiableMap(exportableValue));
            }
            valuesByName.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        }
        return Collections.unmodifiableMap(valuesByName);
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues != null) {
            ArrayList<URLValue> urls = new ArrayList<URLValue>();
            for (Map exportableValue : exportableValues) {
                URLValue url;
                String path = (String)exportableValue.get(PATH);
                String type = (String)exportableValue.get(TYPE);
                String protocolName = (String)exportableValue.get(PROTOCOL);
                String host = (String)exportableValue.get(HOST);
                if (protocolName != null) {
                    try {
                        URLProtocol protocol = new URLProtocolConverter().valueOf(protocolName);
                        url = new URLValue(path, type, protocol, host);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Protocolo " + protocolName + " inv\u00e1lido");
                    }
                } else {
                    url = new URLValue(path, type);
                }
                if (urls.contains(url)) continue;
                urls.add(url);
            }
            if (urls.isEmpty()) {
                this.setValue(null);
            } else {
                this.setValue(urls);
            }
        }
    }

    @Override
    public String getCommandValue(CommandLineContext context) {
        String commandValue = super.getCommandValue(context);
        if (commandValue == null) {
            return null;
        }
        List value = (List)this.getValue();
        if (value == null || value.isEmpty()) {
            return null;
        }
        URLValue url = (URLValue)value.iterator().next();
        URLProtocol protocol = url.getProtocol();
        String f = "%s %s=%s";
        return String.format(f, commandValue, this.getLocalization(), protocol.getType());
    }

    @Override
    public String getCommandItemValue(CommandLineContext context, URLValue url) {
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        if (urlPath.startsWith("$")) {
            return urlPath;
        }
        char fileSeparator = context.getFileSeparator();
        String path = url.getPath(fileSeparator);
        URLProtocol protocol = url.getProtocol();
        switch (protocol) {
            case PROJECT: {
                String filePath = url.getPath(fileSeparator);
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                return CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, filePath, fileSeparator);
            }
        }
        String commandValue = protocol.getCommandValue();
        if (commandValue != null) {
            return String.valueOf(commandValue) + path;
        }
        return path;
    }

    public String getFileType() {
        return this.fileType;
    }

    public FileParameterMode getMode() {
        return this.mode;
    }

    @Override
    public String getValueAsText() {
        List urls = (List)this.getValue();
        if (urls == null || urls.isEmpty()) {
            return null;
        }
        String separator = "";
        StringBuilder valueAsText = new StringBuilder();
        for (URLValue url : urls) {
            String stringValue = URLValue.getStringValue(url);
            if (stringValue == null) continue;
            valueAsText.append(separator);
            valueAsText.append(stringValue);
            separator = "|";
        }
        return valueAsText.toString();
    }

    @Override
    public URLValue getItemValueFromText(String elementAsText) throws ParseException {
        return URLValue.getURLFromString(this.mode, elementAsText);
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        String[] components;
        if (parameterValue == null || parameterValue.length() == 0) {
            this.setValue(null);
            return;
        }
        ArrayList<URLValue> urls = new ArrayList<URLValue>();
        String[] stringArray = components = parameterValue.split("\\|");
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            URLValue url = this.getItemValueFromText(component);
            urls.add(url);
            ++n2;
        }
        this.setValue(urls);
    }

    public void moveUp(int index) {
        List urls = (List)this.getValue();
        if (urls == null) {
            return;
        }
        int size = urls.size();
        if (size == 0 || index == 0) {
            return;
        }
        URLValue element = (URLValue)urls.remove(index);
        urls.add(index - 1, element);
        this.fireValueWasChangedEvent();
    }

    public void moveDown(int index) {
        List urls = (List)this.getValue();
        if (urls == null) {
            return;
        }
        int size = urls.size();
        if (size == 0 || index == size - 1) {
            return;
        }
        URLValue element = (URLValue)urls.remove(index);
        urls.add(index + 1, element);
        this.fireValueWasChangedEvent();
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
        this.fireVisiblityWasChangedEvent();
    }

    protected void setMode(FileParameterMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("O par\u00e2metro mode est\u00e1 nulo.");
        }
        this.mode = mode;
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    public String getLocalization() {
        return this.localization;
    }

    public EnumSet<URLProtocol> getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public URLProtocol getDefaultProtocol() {
        if (this.allowedProtocols.size() == 0) {
            return URLValue.DEFAULT_PROTOCOL;
        }
        return (URLProtocol)((Object)this.allowedProtocols.iterator().next());
    }

    @Override
    public URLListParameterValidator createParameterValidator() {
        return new URLListParameterValidator(this.createItemValidator());
    }

    protected URLParameterValidator createItemValidator() {
        return new URLParameterValidator(this.isOptional());
    }

    public boolean mustExist() {
        return this.mustExist;
    }
}

