/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import java.text.MessageFormat;

public final class SimpleCondition
implements Condition {
    private final String parameterName;
    private final Object value;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SimpleCondition condition = (SimpleCondition)obj;
        String conditionParameterName = condition.getParameterName();
        if (!this.parameterName.equals(conditionParameterName)) {
            return false;
        }
        Object conditionValue = condition.getValue();
        if (this.value == null && conditionValue == null) {
            return true;
        }
        return this.value != null && this.value.equals(conditionValue);
    }

    @Override
    public boolean evaluate(SimpleAlgorithmConfigurator configurator) {
        if (configurator == null) {
            String err = "O par\u00e2metro version est\u00e1 nulo.";
            throw new IllegalArgumentException("O par\u00e2metro version est\u00e1 nulo.");
        }
        SimpleParameter<?> parameter = configurator.getSimpleParameter(this.parameterName);
        if (parameter == null) {
            String fmt = "O par\u00e2metro {1} do algoritmo {0} n\u00e3o foi encontrado.";
            String err = MessageFormat.format("O par\u00e2metro {1} do algoritmo {0} n\u00e3o foi encontrado.", this.parameterName, configurator);
            throw new IllegalStateException(err);
        }
        Object currentValue = parameter.getValue();
        if (this.value == null && currentValue == null) {
            return true;
        }
        return this.value != null && this.value.equals(currentValue);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.parameterName.hashCode();
    }

    public String toString() {
        String toString = "----------\n";
        toString = String.valueOf(toString) + "Classe = " + this.getClass().getName() + "\n";
        toString = String.valueOf(toString) + "Parametro = " + this.getParameterName() + "\n";
        toString = String.valueOf(toString) + "Valor = " + this.getValue() + "\n";
        toString = String.valueOf(toString) + "----------\n";
        return toString;
    }

    public SimpleCondition(String parameterName, Object value) {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        this.parameterName = parameterName;
        this.value = value;
    }
}

