/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.exception.ServiceFailureException;
import csbase.logic.AccessSGAPathPermission;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientSGAFile;
import csbase.logic.User;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.SGAServiceInterface;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.EnumSet;
import tecgraf.javautils.core.io.FileUtils;

public class URLParameterValidator
extends SimpleParameterValidator<URLValue> {
    public URLParameterValidator(boolean optional) {
        super(optional);
    }

    @Override
    public final Validation validateValue(SimpleParameter<?> parameter, URLValue value, ValidationContext context) throws RemoteException {
        if (!parameter.isVisible()) {
            return new ValidationSuccess();
        }
        if (!parameter.isEnabled()) {
            return new ValidationSuccess();
        }
        URLParameter urlParameter = (URLParameter)parameter;
        Validation result = super.validateValue(parameter, value, context);
        if (!result.isWellSucceded()) {
            return result;
        }
        boolean mustExist = urlParameter.mustExist();
        FileParameterMode mode = urlParameter.getMode();
        return this.validateURL(value, urlParameter.getAllowedProtocols(), mustExist, mode, context);
    }

    public Validation validateURL(URLValue url, EnumSet<URLProtocol> allowedProtocols, boolean mustExist, FileParameterMode mode, ValidationContext context) throws RemoteException {
        if (url != null) {
            URLProtocol protocol = url.getProtocol();
            if (!allowedProtocols.contains((Object)protocol)) {
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "invalid_protocol", new Object[]{protocol});
                return new ValidationError(message);
            }
            switch (protocol) {
                case PROJECT: {
                    return this.validateProjectFile(url, context, mustExist, mode);
                }
                case SGA: {
                    return this.validateSGAFile(url, context, mustExist, mode);
                }
                case LOCAL: {
                    return this.validateLocalFile(url, context, mustExist, mode);
                }
            }
            return URLParameterValidator.validateAbsoluteFileName(url);
        }
        return new ValidationSuccess();
    }

    public static Validation validateAbsoluteFileName(URLValue url) {
        String path = url.getPath();
        if (!URLValue.isAbsolutePath(path)) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "not_absolute_path", new Object[]{path});
            return new ValidationError(message);
        }
        String invalidChars = "[^\\w:.\\-_/]";
        String normalizedString = path.replaceAll(invalidChars, "_");
        if (!normalizedString.equals(path)) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "invalid_absolute_file_name", new Object[]{path});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    public static Validation validateProjectFileName(String[] path) {
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            String fixedFileName = FileUtils.fixFileName((String)component);
            if (!fixedFileName.equals(component)) {
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "invalid_file_name", new Object[]{component});
                return new ValidationError(message);
            }
            ++n2;
        }
        return new ValidationSuccess();
    }

    private Validation validateProjectFile(URLValue file, ValidationContext context, boolean mustExist, FileParameterMode mode) throws RemoteException {
        Object projectId = context.getProjectId();
        if (projectId == null) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "no_project", new Object[]{file.getPath()});
            return new ValidationError(message);
        }
        String[] path = file.getPathAsArray();
        Validation fileNameResult = URLParameterValidator.validateProjectFileName(path);
        if (!fileNameResult.isWellSucceded()) {
            return fileNameResult;
        }
        ClientProjectFile projectFile = this.getProjectFile(path, projectId);
        if (projectFile != null) {
            return this.validateFileMode(mode, projectFile);
        }
        if (mustExist) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "file_not_found", new Object[]{file.getPath()});
            return new ValidationError(message);
        }
        return this.validateParent(file, projectId);
    }

    private Validation validateLocalFile(URLValue url, ValidationContext context, boolean mustExist, FileParameterMode mode) throws RemoteException {
        Validation fileNameResult = URLParameterValidator.validateAbsoluteFileName(url);
        if (!fileNameResult.isWellSucceded()) {
            return fileNameResult;
        }
        return new ValidationSuccess();
    }

    private Validation validateSGAFile(URLValue value, ValidationContext context, boolean mustExist, FileParameterMode mode) throws RemoteException {
        Validation fileNameResult = URLParameterValidator.validateAbsoluteFileName(value);
        if (!fileNameResult.isWellSucceded()) {
            return fileNameResult;
        }
        Object userId = context.getUserId();
        User user = User.getUser(userId);
        if (!AccessSGAPathPermission.canReadPath(user, value.getHost(), value.getPath())) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.cannot.read", new Object[]{value.getHost(), value.getPath()});
            return new ValidationError(message);
        }
        String sgaName = value.getHost();
        if (sgaName == null) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.not.defined");
            return new ValidationError(message);
        }
        ClientSGAFile sgaFile = this.getSGAFile(sgaName, value.getPath());
        try {
            if (mustExist && (sgaFile == null || !sgaFile.exists())) {
                if (mode == FileParameterMode.DIRECTORY) {
                    LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.dir.not.found", new Object[]{value.getHost(), value.getPath()});
                    return new ValidationError(message);
                }
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.file.not.found", new Object[]{value.getHost(), value.getPath()});
                return new ValidationError(message);
            }
        }
        catch (IOException e) {
            if (mode == FileParameterMode.DIRECTORY) {
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.dir.not.found", new Object[]{value.getHost(), value.getPath()});
                return new ValidationError(message);
            }
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "sga.file.not.found", new Object[]{value.getHost(), value.getPath()});
            return new ValidationError(message);
        }
        if (sgaFile != null) {
            return this.validateFileMode(mode, sgaFile);
        }
        return new ValidationSuccess();
    }

    private Validation validateFileMode(FileParameterMode mode, ClientFile file) {
        if (mode == FileParameterMode.DIRECTORY && !file.isDirectory()) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "not_directory", new Object[]{file.getStringPath()});
            return new ValidationError(message);
        }
        if (mode == FileParameterMode.REGULAR_FILE && file.isDirectory()) {
            LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "not_file", new Object[]{file.getStringPath()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validateParent(URLValue file, Object projectId) throws RemoteException {
        String[] parentPath = file.getPathAsArray();
        while (parentPath.length > 1) {
            String parentName = (parentPath = Arrays.copyOf(parentPath, parentPath.length - 1))[parentPath.length - 1];
            if (parentName.equals(".")) continue;
            ClientProjectFile parentProjectFile = this.getProjectFile(parentPath, projectId);
            if (parentProjectFile == null) {
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "file_not_found", new Object[]{FileUtils.joinPath((String[])parentPath)});
                return new ValidationError(message);
            }
            if (!parentProjectFile.isDirectory()) {
                LocalizedMessage message = new LocalizedMessage(URLParameterValidator.class, "not_directory", new Object[]{parentProjectFile.getStringPath()});
                return new ValidationError(message);
            }
            return new ValidationSuccess();
        }
        return new ValidationSuccess();
    }

    private ClientProjectFile getProjectFile(String[] path, Object projectId) throws RemoteException {
        try {
            ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
            if (projectService.existsFile(projectId, path)) {
                return projectService.getChild(projectId, path);
            }
            return null;
        }
        catch (ServiceFailureException e) {
            return null;
        }
    }

    private ClientSGAFile getSGAFile(String sgaName, String path) throws RemoteException {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        return sgaService.getFile(sgaName, path);
    }
}

