/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.applicationservice;

import csbase.logic.FileInfo;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.applicationservice.AppPropertyResourceBundle;
import csbase.logic.applicationservice.ApplicationRegistryException;
import csbase.logic.applicationservice.ApplicationRegistryUtilities;
import csbase.remote.ApplicationServiceInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;

public final class ApplicationRegistry
implements Serializable {
    private final List<Pattern> classLoaderWhiteList;
    private final List<Pattern> classLoaderBlackList;
    private byte[] iconDefinition;
    private byte[] imageDefinition;
    private final String id;
    private transient AppPropertyResourceBundle propResBundle = null;
    private final List<String> fileTypes = new ArrayList<String>();
    private Properties properties = null;
    private LNG.TranslationListener callback;
    private Boolean isClosed = false;
    private final long timestamp;
    private FileInfo[] applicationLibs;
    private File classpathBaseDir;
    private static final String APP_NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CLASS_NAME_PROPERTY = "class.name";
    private static final String IS_ENABLED_PROPERTY = "enabled";
    private static final String CLASSPATH_PROPERTY = "classpath";
    private static final String REQUIRE_PROJECT_PROPERTY = "require.project";
    private static final String MAIN_FRAME_IS_VISIBLE_PROPERTY = "main.frame.visible";
    private static final String SHOWN_AT_APP_PANEL_PROPERTY = "shown.at.application.panel";
    private static final String SHOWN_AT_MENU_PROPERTY = "shown.at.application.menu";
    private static final String NEED_BUNDLE_PROPERTY = "need.bundle";
    private static final String APP_COMMAND_PROPERTY = "application.command";
    private static final String AUTHOR_NAME_PROPERTY = "author.name";
    private static final String AUTHOR_MAIL_PROPERTY = "author.mail";
    private static final String VERSION_PROPERTY = "version.number";
    private static final String FILE_TYPES_PROPERTY = "file.types";
    private static final String IS_SINGLETON_PROPERTY = "singleton";
    private static final String ADDITIONAL_LANGUAGE_FILE_PROPERTY = "additional.language.file";
    private static final String EXTERNAL_LANGUAGE_FILE_BASENAME_PROPERTY = "external.language.file.basename";

    public void setTranslationListener(LNG.TranslationListener callback) {
        this.callback = callback;
    }

    public LNG.TranslationListener getTranslationListener() {
        return this.callback;
    }

    public final boolean loadClientBundles(Class<?> mainClass, Locale locale) {
        LinkedList<String> allLanguageFilePathPrefixList = new LinkedList<String>();
        String defaultLanguageFilePathPrefix = this.getDefaultLanguageFilePathPrefix();
        allLanguageFilePathPrefixList.add(defaultLanguageFilePathPrefix);
        List<String> additionalLanguageFilePathPrefixes = this.getStringListSpecificProperty(ADDITIONAL_LANGUAGE_FILE_PROPERTY);
        allLanguageFilePathPrefixList.addAll(additionalLanguageFilePathPrefixes);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        boolean loaded = false;
        AppPropertyResourceBundle resourceBundle = null;
        for (String filePathPrefix : allLanguageFilePathPrefixList) {
            String err;
            String fmt;
            String idiomFileName = String.valueOf(filePathPrefix) + "_" + language + "_" + country + ".properties";
            InputStream in = mainClass.getResourceAsStream(idiomFileName);
            if (in == null) {
                fmt = "(%s) [loadClientBundles] N\u00e3o detectou-se arquivo de idiomas: %s";
                err = String.format("(%s) [loadClientBundles] N\u00e3o detectou-se arquivo de idiomas: %s", this.getId(), idiomFileName);
                this.logBundleLoading(err);
                continue;
            }
            try {
                fmt = "(%s) [loadClientBundles] Carregando arquivo de idiomas: %s";
                err = String.format("(%s) [loadClientBundles] Carregando arquivo de idiomas: %s", this.getId(), idiomFileName);
                this.logBundleLoading(err);
                resourceBundle = new AppPropertyResourceBundle(in, locale, this);
            }
            catch (IOException e) {
                String fmt2 = "(%s) [loadClientBundles] Falha de carga de bundle cliente da aplica\u00e7\u00e3o: %s - %s";
                String err2 = String.format("(%s) [loadClientBundles] Falha de carga de bundle cliente da aplica\u00e7\u00e3o: %s - %s", this.getId(), idiomFileName, e.getMessage());
                this.logBundleLoading(err2);
                continue;
            }
            AppPropertyResourceBundle oldBundle = this.propResBundle;
            this.propResBundle = resourceBundle;
            if (oldBundle != null) {
                this.propResBundle.setParent(oldBundle);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                String fmt3 = "(%s) [loadClientBundles] Falha de close de bundle cliente da aplica\u00e7\u00e3o: %s - %s";
                String err3 = String.format("(%s) [loadClientBundles] Falha de close de bundle cliente da aplica\u00e7\u00e3o: %s - %s", this.getId(), idiomFileName, e.getMessage());
                this.logBundleLoading(err3);
            }
            loaded = true;
        }
        return loaded;
    }

    private void logBundleLoading(String message) {
    }

    public boolean loadServerBundles(ApplicationServiceInterface appService, Locale locale) throws RemoteException {
        String appId = this.getId();
        String fileName = this.getDefaultLanguageFileName(locale);
        String[] path = new String[]{"bundles", fileName};
        RemoteFileChannelInfo info = appService.getApplicationResource(appId, path);
        if (info == null) {
            return false;
        }
        try {
            RemoteFileInputStream stream = new RemoteFileInputStream(info);
            AppPropertyResourceBundle srvBundle = new AppPropertyResourceBundle(stream, locale, this);
            AppPropertyResourceBundle oldBundle = this.propResBundle;
            this.propResBundle = srvBundle;
            if (oldBundle != null) {
                this.propResBundle.setParent(oldBundle);
            }
            String fmt = "(%s) [loadServerBundles] Carga de bundle remoto da aplica\u00e7\u00e3o: %s";
            String err = String.format("(%s) [loadServerBundles] Carga de bundle remoto da aplica\u00e7\u00e3o: %s", this.getId(), fileName);
            this.logBundleLoading(err);
            return true;
        }
        catch (IOException e) {
            String fmt = "(%s) [loadServerBundles] Falha de carga de bundle remoto da aplica\u00e7\u00e3o: %s = %s ";
            String err = String.format("(%s) [loadServerBundles] Falha de carga de bundle remoto da aplica\u00e7\u00e3o: %s = %s ", this.getId(), fileName, e.getMessage());
            this.logBundleLoading(err);
            return false;
        }
    }

    private String getClassSimpleName() {
        String className = this.getClassName();
        int idx = className.lastIndexOf(".");
        int length = className.length();
        String classSimpleName = className.substring(idx + 1, length);
        return classSimpleName;
    }

    private String getDefaultLanguageFileName(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String classSimpleName = this.getClassSimpleName();
        String fileName = String.valueOf(classSimpleName) + "_" + language + "_" + country + ".properties";
        return fileName;
    }

    public final void loadURLBundles(String pathPrefixURL, Locale locale) {
        try {
            List<String> allLanguageURLPrefixList = this.getStringListSpecificProperty(EXTERNAL_LANGUAGE_FILE_BASENAME_PROPERTY);
            AppPropertyResourceBundle resourceBundle = this.propResBundle;
            for (String filePathPrefix : allLanguageURLPrefixList) {
                String idiomFileName = String.valueOf(pathPrefixURL) + filePathPrefix + "_" + locale + ".properties";
                URL url = new URL(idiomFileName);
                InputStream in = url.openStream();
                if (in == null) {
                    throw new IllegalStateException("Falha na carga do arquivo de idiomas: " + filePathPrefix);
                }
                resourceBundle = new AppPropertyResourceBundle(in, locale, this);
                String fmt = "(%s) [loadURLBundles] Carregando arquivo de idiomas: %s";
                String err = String.format("(%s) [loadURLBundles] Carregando arquivo de idiomas: %s", this.getId(), idiomFileName);
                this.logBundleLoading(err);
                AppPropertyResourceBundle oldBundle = this.propResBundle;
                this.propResBundle = resourceBundle;
                if (oldBundle != null) {
                    this.propResBundle.setParent(oldBundle);
                }
                in.close();
            }
        }
        catch (IOException e) {
            String err = "[loadURLBundles] Falha de carga de resource bundle da aplica\u00e7\u00e3o: ";
            String className = this.getClassName();
            throw new IllegalStateException("[loadURLBundles] Falha de carga de resource bundle da aplica\u00e7\u00e3o: " + className + " - " + e.getMessage());
        }
    }

    private String getDefaultLanguageFilePathPrefix() {
        String className = this.getClassName();
        int idx = className.lastIndexOf(".");
        String path = className.substring(0, idx);
        int length = className.length();
        String classLastName = className.substring(idx + 1, length);
        String sep = "/";
        String replaced = path.replace(".", "/");
        String resPath = "/" + replaced + "/" + "resources" + "/" + classLastName;
        return resPath;
    }

    private void loadFileTypes() {
        String[] aux;
        if (this.isPropertyNull(FILE_TYPES_PROPERTY)) {
            return;
        }
        String prop = this.getStringSpecificProperty(FILE_TYPES_PROPERTY);
        String[] stringArray = aux = prop.split(",");
        int n = aux.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.fileTypes.add(element.trim().toUpperCase());
            ++n2;
        }
    }

    private String getClassKeyForInternacionalization(Class<?> clazz, String tag) {
        String prefix = clazz.getSimpleName();
        String key = String.valueOf(prefix) + "." + tag;
        return key;
    }

    public final boolean hasClassString(Class<?> clazz, String key) {
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.hasString(k);
    }

    public final String getClassString(Class<?> clazz, String key) {
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.getString(k);
    }

    public final String getClassString(Class<?> clazz, String key, Object ... args) {
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.getString(k, args);
    }

    public final boolean hasObjectString(Object object, String key) {
        Class<?> clazz = object.getClass();
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.hasString(k);
    }

    public final String getObjectString(Object object, String key) {
        Class<?> clazz = object.getClass();
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.getString(k);
    }

    public final String getObjectString(Object object, String key, Object ... args) {
        Class<?> clazz = object.getClass();
        String k = this.getClassKeyForInternacionalization(clazz, key);
        return this.getString(k, args);
    }

    public final boolean hasString(String key) {
        block3: {
            try {
                if (this.propResBundle != null) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.propResBundle.containsKey(key);
    }

    public final String getString(String key) {
        return this.propResBundle.getString(key);
    }

    public final String getString(String key, Object[] objs) {
        try {
            String pattern = this.getString(key);
            return MessageFormat.format(pattern, objs);
        }
        catch (Exception e) {
            return key == null ? "<<<null>>>" : "<<<" + key + ">>>";
        }
    }

    public final boolean isShownAtApplicationMenu() {
        if (this.isPropertyNull(SHOWN_AT_MENU_PROPERTY)) {
            return true;
        }
        return this.getBooleanSpecificProperty(SHOWN_AT_MENU_PROPERTY);
    }

    public final boolean isShownAtApplicationPanel() {
        if (this.isPropertyNull(SHOWN_AT_APP_PANEL_PROPERTY)) {
            return true;
        }
        return this.getBooleanSpecificProperty(SHOWN_AT_APP_PANEL_PROPERTY);
    }

    public final boolean requireProject() {
        return this.getBooleanSpecificProperty(REQUIRE_PROJECT_PROPERTY);
    }

    public final boolean mainFrameIsVisible() {
        if (this.isPropertyNull(MAIN_FRAME_IS_VISIBLE_PROPERTY)) {
            return true;
        }
        return this.getBooleanSpecificProperty(MAIN_FRAME_IS_VISIBLE_PROPERTY);
    }

    public final String getId() {
        return this.id;
    }

    public final AppPropertyResourceBundle getResourceBundle() {
        return this.propResBundle;
    }

    public final String getClassName() {
        return this.getStringSpecificProperty(CLASS_NAME_PROPERTY);
    }

    public final List<String> getFileTypes() {
        return this.fileTypes;
    }

    public final String getApplicationCommand() {
        if (this.isPropertyNull(APP_COMMAND_PROPERTY)) {
            return null;
        }
        return this.getStringSpecificProperty(APP_COMMAND_PROPERTY);
    }

    public final String getApplicationCommandDir() {
        if (this.isPropertyNull(APP_COMMAND_PROPERTY)) {
            return null;
        }
        String appCommand = this.getStringSpecificProperty(APP_COMMAND_PROPERTY);
        return ApplicationRegistryUtilities.getCommandPath(appCommand);
    }

    public final boolean isEnabled() {
        return this.getBooleanSpecificProperty(IS_ENABLED_PROPERTY);
    }

    public final List<String> getClasspath() {
        if (!this.isPropertyNull(CLASSPATH_PROPERTY)) {
            String[] classpathEntries;
            String classpathAsString = this.getStringSpecificProperty(CLASSPATH_PROPERTY);
            ArrayList<String> classpathList = new ArrayList<String>();
            String[] stringArray = classpathEntries = classpathAsString.split(",");
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String classpathEntry = stringArray[n2];
                String entry = classpathEntry.trim();
                if (!classpathEntry.isEmpty()) {
                    classpathList.add(entry);
                }
                ++n2;
            }
            return classpathList;
        }
        return this.getStringListSpecificProperty(CLASSPATH_PROPERTY);
    }

    public final boolean isRunnable() {
        String appCommand = this.getApplicationCommandDir();
        if (appCommand == null) {
            return true;
        }
        String appCommandDir = ApplicationRegistryUtilities.getCommandPath(appCommand);
        return appCommandDir != null;
    }

    public final boolean isSingleton() {
        return this.getBooleanSpecificProperty(IS_SINGLETON_PROPERTY);
    }

    public final boolean isPropertyNull(String propName) {
        String tag = String.valueOf(this.id) + "." + propName;
        String value = this.properties.getProperty(tag);
        if (value == null) {
            return true;
        }
        return value.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeConfiguration() throws ApplicationRegistryException {
        this.checkProperties();
        this.loadFileTypes();
        this.loadClasspath();
        Boolean bl = this.isClosed;
        synchronized (bl) {
            if (this.isClosed.booleanValue()) {
                throw new IllegalStateException("Registry j\u00e1 fechado!");
            }
            this.isClosed = true;
        }
    }

    public ApplicationRegistry(String id, long timestamp) {
        this.id = id;
        this.properties = new Properties();
        this.timestamp = timestamp;
        this.classLoaderWhiteList = new ArrayList<Pattern>();
        this.classLoaderBlackList = new ArrayList<Pattern>();
    }

    private void checkProperties() throws ApplicationRegistryException {
        String[] mustProperties;
        String[] stringArray = mustProperties = new String[]{CLASS_NAME_PROPERTY, IS_ENABLED_PROPERTY, IS_SINGLETON_PROPERTY, NEED_BUNDLE_PROPERTY, REQUIRE_PROJECT_PROPERTY};
        int n = mustProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String prp = stringArray[n2];
            if (this.isPropertyNull(prp)) {
                String fmt = "Falta propriedade da aplica\u00e7\u00e3o %s (%s).";
                String err = String.format("Falta propriedade da aplica\u00e7\u00e3o %s (%s).", this.id, prp);
                throw new ApplicationRegistryException(err);
            }
            ++n2;
        }
    }

    public void setClasspathBaseDir(File baseDir) {
        this.classpathBaseDir = baseDir;
    }

    private void loadClasspath() throws ApplicationRegistryException {
        List<String> classpath = this.getClasspath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        String separator = "/";
        for (String libPath : classpath) {
            this.checkLibrary(this.classpathBaseDir, libPath);
            String filePath = tecgraf.javautils.core.io.FileUtils.getFilePath((String)libPath, (String)separator);
            String[] splitPath = tecgraf.javautils.core.io.FileUtils.splitPath((String)filePath, (String)separator);
            String fileName = tecgraf.javautils.core.io.FileUtils.getFileName((String)libPath, (String)separator);
            FileInfo fileInfo = splitPath.length > 0 ? new FileInfo(splitPath, fileName, false) : new FileInfo(fileName, false);
            fileInfos.add(fileInfo);
        }
        this.applicationLibs = fileInfos.toArray(new FileInfo[fileInfos.size()]);
    }

    private void checkLibrary(File baseDir, String libPath) throws ApplicationRegistryException {
        boolean isInsideBaseDir;
        File path = new File(baseDir, libPath);
        if (!path.exists()) {
            String fmt = "O arquivo %s do classpath da aplica\u00e7\u00e3o %s n\u00e3o foi encontrado";
            String err = String.format("O arquivo %s do classpath da aplica\u00e7\u00e3o %s n\u00e3o foi encontrado", path, this.id);
            throw new ApplicationRegistryException(err);
        }
        if (path.isDirectory()) {
            String fmt = "O arquivo %s do classpath da aplica\u00e7\u00e3o %s \u00e9 um diret\u00f3rio";
            String err = String.format("O arquivo %s do classpath da aplica\u00e7\u00e3o %s \u00e9 um diret\u00f3rio", path, this.id);
            throw new ApplicationRegistryException(err);
        }
        try {
            isInsideBaseDir = FileUtils.directoryContains((File)baseDir, (File)path);
        }
        catch (IOException e) {
            String fmt = "Erro de ao verificar se o arquivo %s do classpath da aplica\u00e7\u00e3o %s se encontra dentro do diret\u00f3rio da aplica\u00e7\u00e3o %s";
            String err = String.format("Erro de ao verificar se o arquivo %s do classpath da aplica\u00e7\u00e3o %s se encontra dentro do diret\u00f3rio da aplica\u00e7\u00e3o %s", path, this.id, baseDir);
            throw new ApplicationRegistryException(err);
        }
        if (!isInsideBaseDir) {
            String fmt = "O arquivo %s do classpath da aplica\u00e7\u00e3o %s n\u00e3o se encontra dentro do diret\u00f3rio da aplica\u00e7\u00e3o %s";
            String err = String.format("O arquivo %s do classpath da aplica\u00e7\u00e3o %s n\u00e3o se encontra dentro do diret\u00f3rio da aplica\u00e7\u00e3o %s", path, this.id, baseDir);
            throw new ApplicationRegistryException(err);
        }
    }

    public final boolean isBundleRequired() {
        return this.getBooleanSpecificProperty(NEED_BUNDLE_PROPERTY);
    }

    public final List<String> getStringListSpecificProperty(String name) {
        String pName;
        LinkedList<String> list = new LinkedList<String>();
        int i = 1;
        while (!this.isPropertyNull(pName = String.valueOf(name) + "." + i)) {
            String value = this.getStringSpecificProperty(pName);
            list.add(value);
            ++i;
        }
        return Collections.unmodifiableList(list);
    }

    public final byte[] getImageDefinition() {
        return this.imageDefinition;
    }

    public final byte[] getIconDefinition() {
        return this.iconDefinition;
    }

    private String getLocaledProperty(String propertyName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        Object[] args = new Object[]{language, country};
        String key = String.valueOf(propertyName) + ".{0}.{1}";
        String fmtKey = MessageFormat.format(key, args);
        if (this.isPropertyNull(fmtKey)) {
            Locale nativeLocale = LNG.getNativeLocale();
            if (nativeLocale != null && !locale.equals(LNG.getNativeLocale())) {
                return this.getLocaledProperty(propertyName, nativeLocale);
            }
            return "<<" + fmtKey + ">>>";
        }
        String value = this.getStringSpecificProperty(fmtKey);
        return value;
    }

    public final String getAuthorMail() {
        if (this.isPropertyNull(AUTHOR_MAIL_PROPERTY)) {
            return "-";
        }
        return this.getStringSpecificProperty(AUTHOR_MAIL_PROPERTY);
    }

    public final String getAuthorName() {
        if (this.isPropertyNull(AUTHOR_NAME_PROPERTY)) {
            return "-";
        }
        return this.getStringSpecificProperty(AUTHOR_NAME_PROPERTY);
    }

    private int getVersionNumber(String vTxt) {
        int pt;
        int mn;
        int mj;
        if (vTxt == null) {
            return 0;
        }
        String txt = vTxt.trim();
        if (txt.equals("")) {
            return 0;
        }
        String[] elems = txt.split("\\.");
        if (elems == null || elems.length != 3) {
            return 0;
        }
        try {
            mj = Integer.parseInt(elems[0]);
        }
        catch (Throwable t) {
            mj = 0;
        }
        try {
            mn = Integer.parseInt(elems[1]);
        }
        catch (Throwable t) {
            mn = 0;
        }
        try {
            pt = Integer.parseInt(elems[2]);
        }
        catch (Throwable t) {
            pt = 0;
        }
        return mj * 1000000 + mn * 1000 + pt;
    }

    public final int getVersionNumber() {
        return this.getVersionNumber(this.getVersion());
    }

    public final String getVersion() {
        if (this.isPropertyNull(VERSION_PROPERTY)) {
            return "0.0.0";
        }
        return this.getStringSpecificProperty(VERSION_PROPERTY);
    }

    public final int getIntSpecificProperty(String propName) {
        String str = this.getStringSpecificProperty(propName);
        try {
            int value = Integer.parseInt(str);
            return value;
        }
        catch (Exception e) {
            String err = "Propriedade " + propName + " inteira mal formatada";
            throw new IllegalStateException(String.valueOf(err) + " - applica\u00e7\u00e3o:" + this.getId());
        }
    }

    public final long getLongSpecificProperty(String propName) {
        String str = this.getStringSpecificProperty(propName);
        try {
            long value = Long.parseLong(str);
            return value;
        }
        catch (Exception e) {
            String err = "Propriedade " + propName + " long mal formatada";
            throw new IllegalStateException(String.valueOf(err) + " - applica\u00e7\u00e3o:" + this.getId());
        }
    }

    public final boolean getBooleanSpecificProperty(String propName) {
        String[] accepts;
        String str = this.getStringSpecificProperty(propName);
        String[] stringArray = accepts = new String[]{"true", "false"};
        int n = accepts.length;
        int n2 = 0;
        while (n2 < n) {
            String acc = stringArray[n2];
            if (acc.equals(str.trim())) {
                boolean value = Boolean.parseBoolean(str);
                return value;
            }
            ++n2;
        }
        String err = "Propriedade " + propName + " booleana mal formatada";
        throw new IllegalArgumentException(String.valueOf(err) + " - aplica\u00e7\u00e3o:" + this.getId());
    }

    public final String getStringSpecificProperty(String propName) {
        if (this.isPropertyNull(propName)) {
            String err = "Prop. indefinida [" + propName + "] para apl. " + this.id;
            throw new IllegalStateException(err);
        }
        String tag = String.valueOf(this.id) + "." + propName;
        String value = this.properties.getProperty(tag);
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return null;
        }
        return value.trim();
    }

    public final double getDoubleSpecificProperty(String propName) {
        String str = this.getStringSpecificProperty(propName);
        try {
            double value = Double.parseDouble(str);
            return value;
        }
        catch (Exception e) {
            String err = "Propriedade " + propName + " double mal formatada";
            throw new IllegalStateException(String.valueOf(err) + " - applica\u00e7\u00e3o:" + this.getId());
        }
    }

    public final Properties getSpecificProperties() {
        return this.properties;
    }

    public final String toString() {
        return this.getId();
    }

    public final String getApplicationName(Locale locale) {
        return this.getLocaledProperty(APP_NAME_PROPERTY, locale);
    }

    public final String getApplicationDescription(Locale locale) {
        return this.getLocaledProperty(DESCRIPTION_PROPERTY, locale);
    }

    public final void setIconDefinition(byte[] img16) {
        this.checkClosed();
        this.iconDefinition = img16;
    }

    public final void setImageDefinition(byte[] img32) {
        this.checkClosed();
        this.imageDefinition = img32;
    }

    public final void setSpecificProperties(Properties prop) {
        this.checkClosed();
        this.properties = prop;
    }

    public final void setClassLoaderWhiteList(List<Pattern> whiteList) {
        this.checkClosed();
        this.classLoaderWhiteList.addAll(whiteList);
    }

    public final void setClassLoaderBlackList(List<Pattern> blackList) {
        this.checkClosed();
        this.classLoaderBlackList.addAll(blackList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClosed() throws IllegalStateException {
        Boolean bl = this.isClosed;
        synchronized (bl) {
            if (this.isClosed.booleanValue()) {
                String err = "ApplicationRegistry bloqueado!";
                throw new IllegalStateException("ApplicationRegistry bloqueado!");
            }
        }
    }

    public List<Pattern> getClassLoaderWhiteList() {
        return Collections.unmodifiableList(this.classLoaderWhiteList);
    }

    public List<Pattern> getClassLoaderBlackList() {
        return Collections.unmodifiableList(this.classLoaderBlackList);
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public FileInfo[] getApplicationLibs() {
        return this.applicationLibs;
    }
}

