/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;
import java.util.regex.Pattern;

public class ProjectFileNameFilter
implements ProjectFileFilter {
    private Pattern namePattern;

    public ProjectFileNameFilter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        name = name.replaceAll("\\.", "\\\\.");
        name = name.replaceAll("\\?", "\\.");
        if (((name = name.replaceAll("\\*", "\\.\\*")).length() == 0 || name.charAt(name.length() - 1) != '*') && name.indexOf(36) == -1) {
            name = String.valueOf(name) + ".*";
        }
        this.namePattern = Pattern.compile(name, 2);
    }

    @Override
    public boolean accept(ClientProjectFile file) {
        boolean result = this.nameMatches(file);
        return result;
    }

    private boolean nameMatches(ClientProjectFile file) {
        return this.namePattern.matcher(file.getName()).matches();
    }
}

