package csbase.logic;

/**
 * Informaes simples sobre a finalizao de um comando (utilizada para guardar
 * informaes algoritmos simples ou de fluxos sem as informaes individuais
 * dos ns).
 */
public class SimpleCommandFinalizationInfo extends
  AbstractCommandFinalizationInfo {

  /**
   * Construtor.
   * 
   * @param finalizationType tipo de finalizao do comando.
   */
  public SimpleCommandFinalizationInfo(CommandFinalizationType finalizationType) {
    this(finalizationType, (Integer) null);
  }

  /**
   * Construtor.
   * 
   * @param finalizationType tipo de finalizao do comando.
   * @param failureCause o tipo da falha que causou a finalizao do comando ou
   *        null caso o comando no tenha falhado.
   */
  public SimpleCommandFinalizationInfo(
    CommandFinalizationType finalizationType,
    FailureFinalizationType failureCause) {
    this(finalizationType, failureCause, null);
  }

  /**
   * Construtor.
   * 
   * @param finalizationType tipo de finalizao do comando.
   * @param exitCode cdigo de sada do comando.
   */
  public SimpleCommandFinalizationInfo(
    CommandFinalizationType finalizationType, Integer exitCode) {
    this(finalizationType, null, exitCode);
  }

  /**
   * Construtor.
   * 
   * @param finalizationType tipo de finalizao do comando.
   * @param failureCause o tipo da falha que causou a finalizao do comando ou
   *        null caso o comando no tenha falhado.
   * @param exitCode cdigo de sada do comando.
   */
  public SimpleCommandFinalizationInfo(
    CommandFinalizationType finalizationType,
    FailureFinalizationType failureCause, Integer exitCode) {
    super(FinalizationInfoType.SIMPLE, finalizationType, failureCause, exitCode);
  }

}
