package csbase.logic.algorithms.validation;

import java.io.Serializable;

/**
 * Interface de um resultado de validao.
 */
public interface Validation extends Serializable {

  /**
   * Obtm a mensagem de erro.
   * 
   * @return A mensagem de erro ou {@code null} se no houve erro.
   */
  public abstract LocalizedMessage getMessage();

  /**
   * Indica se houve sucesso ou falha.
   * 
   * @return {@code true} sucesso ou {@code false} falha.
   */
  public abstract boolean isWellSucceded();

}