package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;

/**
 * 
 * <p>
 * Fbrica de parmetros do tipo "arquivo de entrada":
 * {@link InputFileParameter} e {@link InputFileListParameter}. Como esses dois
 * parmetros podem ser criados a partir de uma mesma tag XML, essa fbrica foi
 * criada para direcionar a anlise para o parser apropriado para cada um dos
 * casos.
 * </p>
 * 
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link InputFileParameterParser#INPUT_FILE_PARAMETER_ELEMENT}.
 * </p>
 * 
 */
public class InputFileParameterFactory extends FileParameterFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputFileListParameterParser createFileListParser() {
    return new InputFileListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputFileParameterParser createSimpleFileParser() {
    return new InputFileParameterParser();
  }

}
