package csbase.logic.server;

/**
 * Representa um evento de adio de {@link ServerInfo informaes de um
 * servidor} no repositrio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ServerInfoAddEvent extends ServerInfoEvent {
  /** {@ServerInfo} adicionado. */
  private ServerInfo serverInfo;

  /**
   * Cria um evento de adio de um {@ServerInfo}.
   *
   * @param serverInfo O {@ServerInfo} que foi adicionado.
   */
  public ServerInfoAddEvent(ServerInfo serverInfo) {
    super(ServerInfoEventType.ADD);
    this.serverInfo = serverInfo;
  }

  /**
   * Obtm o {@ServerInfo} adicionado.
   *
   * @return O {@ServerInfo} adicionado.
   */
  public ServerInfo getServerInfo() {
    return this.serverInfo;
  }
}
