/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ParameterGroup
extends Parameter<Object> {
    private List<ParameterGroup> groups;
    private List<InputFileListParameter> inputFileListParameters;
    private List<InputFileParameter> inputParameters;
    private List<OutputFileListParameter> outputFileListParameters;
    private List<OutputFileParameter> outputParameters;
    private List<InputURLListParameter> inputURLListParameters;
    private List<InputURLParameter> inputURLParameters;
    private List<OutputURLListParameter> outputURLListParameters;
    private List<OutputURLParameter> outputURLParameters;
    private List<Parameter<?>> parameters;
    private ParameterLoader parameterLoader;
    private Map<String, SimpleParameter<?>> simpleParametersByName;
    private String label;
    private boolean isCollapsible;

    public ParameterGroup(String id, String label, boolean isCollapsible) {
        super(id);
        this.setLabel(label);
        this.setCollapsible(isCollapsible);
        this.groups = new LinkedList<ParameterGroup>();
        this.inputParameters = new LinkedList<InputFileParameter>();
        this.inputFileListParameters = new LinkedList<InputFileListParameter>();
        this.outputParameters = new LinkedList<OutputFileParameter>();
        this.outputFileListParameters = new LinkedList<OutputFileListParameter>();
        this.inputURLParameters = new LinkedList<InputURLParameter>();
        this.outputURLParameters = new LinkedList<OutputURLParameter>();
        this.parameters = new LinkedList();
        this.simpleParametersByName = new HashMap();
        this.parameterLoader = null;
    }

    public ParameterGroup(String id) {
        this(id, id, false);
    }

    public boolean addParameter(Parameter<?> parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameter est\u00e1 nulo.");
        }
        if (this.parameters.contains(parameter)) {
            return false;
        }
        if (parameter instanceof SimpleParameter) {
            if (parameter instanceof InputFileParameter) {
                this.inputParameters.add((InputFileParameter)parameter);
            } else if (parameter instanceof OutputFileParameter) {
                this.outputParameters.add((OutputFileParameter)parameter);
            } else if (parameter instanceof InputFileListParameter) {
                this.inputFileListParameters.add((InputFileListParameter)parameter);
            } else if (parameter instanceof OutputFileListParameter) {
                this.outputFileListParameters.add((OutputFileListParameter)parameter);
            } else if (parameter instanceof InputURLParameter) {
                this.inputURLParameters.add((InputURLParameter)parameter);
            } else if (parameter instanceof OutputURLParameter) {
                this.outputURLParameters.add((OutputURLParameter)parameter);
            }
            SimpleParameter simpleParameter = (SimpleParameter)parameter;
            this.simpleParametersByName.put(simpleParameter.getName(), simpleParameter);
        } else if (parameter instanceof ParameterGroup) {
            ParameterGroup group = (ParameterGroup)parameter;
            this.groups.add(group);
        }
        this.parameters.add(parameter);
        return true;
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        for (Parameter<?> parameter : this.parameters) {
            Map<String, Object> values = parameter.exportValue();
            for (String key : values.keySet()) {
                parameterValues.put(key, values.get(key));
            }
        }
        return Collections.unmodifiableMap(parameterValues);
    }

    @Override
    public String getCommandLine(CommandLineContext context) {
        String commandLine = "";
        String separator = "";
        for (Parameter<?> parameter : this.parameters) {
            String parameterCommandLine = parameter.getCommandLine(context);
            if (parameterCommandLine == null) continue;
            commandLine = commandLine + separator;
            commandLine = commandLine + parameter.getCommandLine(context);
            separator = " ";
        }
        if (commandLine.length() == 0) {
            return null;
        }
        return commandLine;
    }

    public Set<ParameterGroup> getGroups() {
        HashSet<ParameterGroup> childGroups = new HashSet<ParameterGroup>();
        childGroups.addAll(this.groups);
        for (ParameterGroup group : childGroups) {
            childGroups.addAll(group.getGroups());
        }
        return childGroups;
    }

    public List<InputFileListParameter> getInputFileListParameters() {
        LinkedList<InputFileListParameter> params = new LinkedList<InputFileListParameter>();
        params.addAll(this.inputFileListParameters);
        for (ParameterGroup group : this.getGroups()) {
            params.addAll(group.getInputFileListParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public List<OutputFileListParameter> getOutputFileListParameters() {
        LinkedList<OutputFileListParameter> params = new LinkedList<OutputFileListParameter>();
        params.addAll(this.outputFileListParameters);
        for (ParameterGroup group : this.getGroups()) {
            params.addAll(group.getOutputFileListParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public List<InputFileParameter> getInputFileParameters() {
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        inputFileParameters.addAll(this.inputParameters);
        for (ParameterGroup group : this.getGroups()) {
            inputFileParameters.addAll(group.getInputFileParameters());
        }
        return Collections.unmodifiableList(inputFileParameters);
    }

    public List<OutputFileParameter> getOutputFileParameters() {
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        outputFileParameters.addAll(this.outputParameters);
        for (ParameterGroup group : this.getGroups()) {
            outputFileParameters.addAll(group.getOutputFileParameters());
        }
        return Collections.unmodifiableList(outputFileParameters);
    }

    public List<InputURLListParameter> getInputURLListParameters() {
        LinkedList<InputURLListParameter> params = new LinkedList<InputURLListParameter>();
        params.addAll(this.inputURLListParameters);
        for (ParameterGroup group : this.getGroups()) {
            params.addAll(group.getInputURLListParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public List<OutputURLListParameter> getOutputURLListParameters() {
        LinkedList<OutputURLListParameter> params = new LinkedList<OutputURLListParameter>();
        params.addAll(this.outputURLListParameters);
        for (ParameterGroup group : this.getGroups()) {
            params.addAll(group.getOutputURLListParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public List<InputURLParameter> getInputURLParameters() {
        LinkedList<InputURLParameter> inputURLParameters = new LinkedList<InputURLParameter>();
        inputURLParameters.addAll(this.inputURLParameters);
        for (ParameterGroup group : this.getGroups()) {
            inputURLParameters.addAll(group.getInputURLParameters());
        }
        return Collections.unmodifiableList(inputURLParameters);
    }

    public List<OutputURLParameter> getOutputURLParameters() {
        LinkedList<OutputURLParameter> outputURLParameters = new LinkedList<OutputURLParameter>();
        outputURLParameters.addAll(this.outputURLParameters);
        for (ParameterGroup group : this.getGroups()) {
            outputURLParameters.addAll(group.getOutputURLParameters());
        }
        return Collections.unmodifiableList(outputURLParameters);
    }

    public ParameterLoader getParameterLoader() {
        return this.parameterLoader;
    }

    public List<Parameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public SimpleParameter<?> getSimpleParameter(String parameterName) {
        SimpleParameter<?> parameter = this.simpleParametersByName.get(parameterName);
        if (parameter == null) {
            for (ParameterGroup group : this.getGroups()) {
                parameter = group.getSimpleParameter(parameterName);
            }
        }
        return parameter;
    }

    public Set<SimpleParameter<?>> getSimpleParameters() {
        HashSet simpleParameters = new HashSet();
        simpleParameters.addAll(this.simpleParametersByName.values());
        for (ParameterGroup group : this.getGroups()) {
            simpleParameters.addAll(group.getSimpleParameters());
        }
        return Collections.unmodifiableSet(simpleParameters);
    }

    @Override
    public void importValue(Map parameterValue) {
        if (parameterValue == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterValues est\u00e1 nulo.");
        }
        for (Parameter<?> parameter : this.parameters) {
            parameter.importValue(parameterValue);
        }
    }

    @Override
    public boolean isSetDefaultValue() {
        for (Parameter<?> parameter : this.getParameters()) {
            if (parameter.isSetDefaultValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        for (Parameter<?> parameter : this.parameters) {
            if (!parameter.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetValue() {
        for (Parameter<?> parameter : this.parameters) {
            parameter.resetValue();
        }
    }

    public boolean setParameterLoader(ParameterLoader parameterLoader) {
        if (this.parameterLoader != null) {
            return false;
        }
        if (parameterLoader == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterLoader est\u00e1 nulo.");
        }
        this.parameterLoader = parameterLoader;
        return true;
    }

    @Override
    public Validation validate(ValidationContext context) throws RemoteException {
        for (Parameter<?> parameter : this.parameters) {
            Validation validation = parameter.validate(context);
            if (validation.isWellSucceded()) continue;
            return validation;
        }
        return new ValidationSuccess();
    }

    @Override
    public boolean setVisible(boolean isVisible) {
        boolean changedVisibility = false;
        for (Parameter<?> parameter : this.parameters) {
            if (isVisible == parameter.isVisible() || !parameter.setVisible(isVisible)) continue;
            changedVisibility = true;
        }
        return changedVisibility;
    }

    public boolean setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        if (label.equals(this.label)) {
            return false;
        }
        this.label = label;
        return true;
    }

    public final String getLabel() {
        return this.label;
    }

    public boolean isCollapsible() {
        return this.isCollapsible;
    }

    public void setCollapsible(boolean isCollapsible) {
        this.isCollapsible = isCollapsible;
    }
}

