/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;

public final class FormulaParameterValidator
extends SimpleParameterValidator<String> {
    public FormulaParameterValidator(boolean isOptional) {
        super(isOptional);
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, String value, ValidationContext context) throws RemoteException {
        Validation result = super.validateValue(parameter, value, context);
        if (!result.isWellSucceded()) {
            return result;
        }
        FormulaParameter formulaParameter = (FormulaParameter)parameter;
        String commandValue = formulaParameter.getEncodedValue(value);
        if (commandValue != null && !commandValue.matches("[A-Za-z0-9_]+")) {
            LocalizedMessage message = new LocalizedMessage(FormulaParameterValidator.class, "message", new Object[]{parameter.getName(), value});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }
}

