/**
 * $Id: LogAdministrationServiceInterface.java 127566 2012-03-26 17:07:10Z fpina
 * $
 */
package csbase.remote;

import java.rmi.RemoteException;

import csbase.logic.LogFile;
import csbase.logic.LogFileInfo;
import csbase.logic.diagnosticservice.LogType;

/**
 * Interface remota para acesso ao servio de administrao dos arquivos de log.
 * 
 * @author Tecgraf
 */
public interface LogAdministrationServiceInterface extends ServiceInterface {

  /** Nome do servio para o <code>ServiceManager</code> */
  public static final String SERVICE_NAME = "LogAdministrationService";

  /**
   * Obtm os tipos de logs disponveis
   * 
   * @return lista dos logs disponveis
   * 
   * @throws RemoteException
   */
  public LogType[] getLogTypes() throws RemoteException;

  /**
   * Obtm os caminhos dos arquivos de log do servidor.
   * 
   * @param type tipo de arquivo de log
   * @param path caminho do qual listar os arquivos
   * 
   * @return lista com os caminhos dos arquivos de log
   * 
   * @throws RemoteException
   */
  public LogFileInfo[] listLogFiles(String type, String path)
    throws RemoteException;

  /**
   * Envia para o email uma lista de arquivos de log para o suporte.
   * 
   * @param body contedo do email
   * @param filesPaths lista de caminhos de arquivos de log
   * 
   * @return flag indicativo de sucesso
   * 
   * @throws RemoteException
   */
  public boolean sendlLogFilesToSuport(final String body,
    final String[] filesPaths) throws RemoteException;

  /**
   * Envia para o email uma lista de arquivos de log para o administrador.
   * 
   * @param body contedo do email
   * @param filesPaths lista de caminhos de arquivos de log
   * 
   * @return flag indicativo de sucesso
   * 
   * @throws RemoteException
   * 
   */
  public boolean sendlLogFilesToAdmin(final String body,
    final String[] filesPaths) throws RemoteException;

  /**
   * Faz o download do arquivo de log.
   * 
   * @param paths caminhos dos arquivos de log
   * 
   * @return Array de String com o contedo dos arquivos
   * 
   * @throws RemoteException
   */
  public LogFile[] downloadLogFile(final String[] paths) throws RemoteException;
}
