/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.CSBaseException;
import csbase.logic.MonitoredServer;
import csbase.logic.ServerManager;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import java.rmi.RemoteException;

public abstract class SingleServerManager
extends ServerManager {
    private SingleMonitoredServer singleMonitoredServer;

    protected abstract String lang(String var1);

    protected abstract Session login() throws CSBaseException, RemoteException;

    public SingleServerManager(ServerURI serverURI, Class<?> locator, int windowSize) {
        this(serverURI, locator, true, windowSize);
    }

    public SingleServerManager(ServerURI serverURI, Class<?> locator, boolean verbose, int windowSize) {
        super(true, verbose);
        if (serverURI == null) {
            throw new IllegalArgumentException("URI n\u00e3o pode ser nula!");
        }
        this.singleMonitoredServer = new SingleMonitoredServer(serverURI, locator, verbose, windowSize);
        this.addServer(this.singleMonitoredServer);
    }

    public final boolean lookup() throws CSBaseException, RemoteException {
        if (super.performLookup()) {
            return super.validate();
        }
        throw new CSBaseException("Servidor fora do ar.");
    }

    public final synchronized void stop() {
        this.getMonitor().stopMonitoring();
        this.removeObservers();
        this.logout(true);
    }

    public final void startMonitoring() {
        this.getMonitor().startMonitoring();
    }

    public final boolean ping() {
        return this.getMonitor().ping();
    }

    public final void setSystemName(String systemName) {
        this.setSystemName(this.singleMonitoredServer.getURI(), systemName);
    }

    public final void logout() {
        this.logout(true);
    }

    final class SingleMonitoredServer
    extends MonitoredServer {
        protected SingleMonitoredServer(ServerURI serverURI, Class<?> locator, int windowSize) {
            this(serverURI, locator, true, windowSize);
        }

        protected SingleMonitoredServer(ServerURI serverURI, Class<?> locator, boolean verbose, int windowSize) {
            super(serverURI, locator, false, verbose, windowSize);
        }

        @Override
        public Session performLogin() throws CSBaseException, RemoteException {
            return SingleServerManager.this.login();
        }

        @Override
        public void postLogin() throws CSBaseException {
        }

        @Override
        protected String lng(String key) {
            return SingleServerManager.this.lang(key);
        }
    }
}

