package csbase.logic.server;

import java.io.Serializable;

import csbase.remote.ServerServiceInterface;

/**
 * Representa uma enumerao com os tipos de evento possveis gerados pelo
 * {@link ServerServiceInterface servio de servidores}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ServerInfoEventType implements Serializable {
  /** O identificador do tipo adicionar. */
  private static final int ADD_ID = 0;

  /** O identificador do tipo modificar. */
  private static final int MODIFY_ID = 1;

  /** O identificador do tipo remover. */
  private static final int REMOVE_ID = 2;

  /**
   * <p>
   * O tipo adicionar.
   * </p>
   * <p>
   *  gerado quando informaes de um servidor local  adicionado ao
   * repositrio de servidores locais.
   * </p>
   */
  public static final ServerInfoEventType ADD =
    new ServerInfoEventType(ADD_ID);

  /**
   * <p>
   * O tipo modificar.
   * </p>
   * <p>
   *  gerado quando informaes de um servidor local  modificado no
   * repositrio de servidores locais.
   * </p> 
   */
  public static final ServerInfoEventType MODIFY =
    new ServerInfoEventType(MODIFY_ID);

  /**
   * <p>
   * O tipo remover.
   * </p>
   * <p>
   *  gerado quando informaes de um servidor local  removido do
   * repositrio de servidores locais.
   * </p>
   */
  public static final ServerInfoEventType REMOVE =
    new ServerInfoEventType(REMOVE_ID);

  /** O identificador do tipo de evento. */
  private Integer id;

  /**
   * Construtor.
   *
   * @param id O identificador do tipo de evento.
   */
  private ServerInfoEventType(int id) {
    this.id = new Integer(id);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!this.getClass().equals(obj.getClass())) {
      return false;
    }
    ServerInfoEventType type = (ServerInfoEventType)obj;
    return this.id.equals(type.id);
  }

  /**
   * {@inheritDoc}
   */
  @Override  
  public int hashCode() {
    return this.id.hashCode();
  }
}
