/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProjectFileTypeInfo
implements Serializable {
    private String code;
    private String description;
    private String mimeType;
    private byte[] baseIcon;
    private byte[] ucIcon;
    private byte[] cutIcon;
    private Set<String> extensions;
    private boolean isDirectory;

    public ProjectFileTypeInfo(String code, String description, String mimeType, byte[] baseIcon, byte[] ucIcon, byte[] cutIcon, Set<String> extensions, boolean isDirectory) {
        this.setCode(code);
        this.setDescription(description);
        this.setMimeType(mimeType);
        this.setBaseIcon(baseIcon);
        this.setUnderConstruction(ucIcon);
        this.setCutIcon(cutIcon);
        this.setExtensions(extensions);
        this.setDirectory(isDirectory);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getBaseIcon() {
        return this.baseIcon;
    }

    public byte[] getUnderConstructionIcon() {
        return this.ucIcon;
    }

    public byte[] getCutIcon() {
        return this.cutIcon;
    }

    public Set<String> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private void setCode(String code) {
        if (code == null) {
            throw new IllegalArgumentException("code == null");
        }
        this.code = code;
    }

    private void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description == null");
        }
        this.description = description;
    }

    private void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType == null");
        }
        this.mimeType = mimeType;
    }

    private void setBaseIcon(byte[] baseIcon) {
        if (baseIcon == null) {
            throw new IllegalArgumentException("baseIcon == null");
        }
        this.baseIcon = Arrays.copyOf(baseIcon, baseIcon.length);
    }

    private void setUnderConstruction(byte[] ucIcon) {
        if (ucIcon == null) {
            throw new IllegalArgumentException("ucIcon == null");
        }
        this.ucIcon = Arrays.copyOf(ucIcon, ucIcon.length);
    }

    private void setCutIcon(byte[] cutIcon) {
        if (cutIcon == null) {
            throw new IllegalArgumentException("cutIcon == null");
        }
        this.cutIcon = Arrays.copyOf(cutIcon, cutIcon.length);
    }

    private void setExtensions(Set<String> extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("extensions == null");
        }
        this.extensions = new HashSet<String>();
        this.extensions.addAll(extensions);
    }

    private void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }
}

