/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.TableColumnFactory;

public abstract class AbstractTableColumnFactory
implements TableColumnFactory {
    protected static final String COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE = "padrao";
    private static final String COLUMN_ELEMENT_ID_ATTRIBUTE = "id";
    private static final String COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE = "editavel";
    private static final boolean COLUMN_ELEMENT_IS_EDITABLE_DEFAULT_VALUE = true;
    private static final String COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE = "opcional";
    private static final boolean COLUMN_ELEMENT_IS_OPTIONAL_DEFAULT_VALUE = false;
    private static final String COLUMN_ELEMENT_LABEL_ATTRIBUTE = "rotulo";
    private String elementName;

    protected AbstractTableColumnFactory(String elementName) {
        this.elementName = elementName;
    }

    @Override
    public final String getElementName() {
        return this.elementName;
    }

    @Override
    public final TableColumn<?> createColumn(XmlParser parser, String name, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String elementName = parser.getElementName();
        if (!elementName.equals(this.elementName)) {
            throw new ParseException("O elemento {0} n\u00e3o \u00e9 suportado por esta f\u00e1brica. Tipo suportado: {1}.", elementName, this.elementName);
        }
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        boolean isOptional = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE, false);
        boolean isEditable = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE, true);
        return this.createColumn(parser, name, label, id, isOptional, isEditable, configurator);
    }

    @Override
    public abstract void setCellValue(XmlParser var1, String var2, TableColumn<?> var3, int var4, String var5) throws ParseException;

    protected abstract TableColumn<?> createColumn(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, SimpleAlgorithmConfigurator var7) throws ParseException;
}

