package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;

/**
 * Classe abstrata que serve de base para analisadores de parmetros {@code <T>}
 * com  * valores numricos inteiros como {@link IntegerParameter} e
 * {@link IntegerListParameter}.
 */
public interface IntegerStructureAttributes {

  /**
   * O atributo {@value #INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link IntegerColumn} de um {@link TableParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * </ul>
   * <p>
   * Indica o valor mximo,  opcional e  do tipo inteiro.
   * </p>
   */
  public static final String INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE = "maximo";

  /**
   * O atributo {@value #INTEGER_ELEMENT_MINIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link IntegerColumn} de um {@link TableParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * </ul>
   * <p>
   * Indica o valor mnimo,  opcional e  do tipo inteiro.
   * </p>
   */
  public static final String INTEGER_ELEMENT_MINIMUM_ATTRIBUTE = "minimo";

  /**
   * Cria a estrutura base de parmetros de inteiro.
   *
   * @param tag nome do parmetro.
   * @param parameterClass classe do parmetro.
   * @return a estrutura do parmetro.
   */
  public default <T extends SimpleParameter<?>> ParameterStructure<T>
  getIntegerStructure(
    String tag, Class<T> parameterClass) {
    ParameterStructure<T> structure =
      new SimpleParameterStructure<>(tag, parameterClass);
    IntegerAttribute maximumAttribute =
      new IntegerAttribute(INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE, null);
    structure.addAttribute(maximumAttribute);
    IntegerAttribute minimumAttribute =
      new IntegerAttribute(INTEGER_ELEMENT_MINIMUM_ATTRIBUTE, null);
    minimumAttribute.setMaximumValueAttribute(maximumAttribute);
    structure.addAttribute(minimumAttribute);
    return structure;
  }

}