package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * Fbrica-base para a criao de parmetros do tipo URL.
 * 
 * @author Tecgraf
 */
public abstract class URLParameterFactory implements MultipleParameterFactory {

  /**
   * <p>
   * O atributo {@value #URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE} dos
   * elementos {@link InputURLParameter} e {@link InputURLListParameter}. Indica
   * se o parmetro aceita seleo mltipla. Caso positivo, o parmetro deve ser
   * instanciado como {@link InputURLListParameter}, caso contrrio, ser um
   * {@link InputURLParameter}.
   * </p>
   * <p>
   * Indica se o arquivo de entrada aceita seleo mltipla,  opcional, o seu
   * valor-padro 
   * {@link #URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE} e  do tipo
   * booleano.
   * </p>
   */
  public static final String URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE =
    "selecao_multipla";

  /**
   * <p>
   * O valor-padro para o atributo
   * {@link #URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE} dos elementos
   * {@link InputURLParameter} e {@link InputURLListParameter}.
   * </p>
   * <p>
   * O seu valor 
   * {@value #URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE}.
   * </p>
   */
  public static final boolean URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE =
    false;

  /**
   * {@inheritDoc}
   */
  @Override
  public Parameter<?> createParameter(XmlParser parser,
    String commandLinePattern, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    boolean isMultipleSelection = parser.extractAttributeValueAsBoolean(
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE,
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE);
    AbstractURLParameterParser<?> fileParser = null;
    if (isMultipleSelection) {
      fileParser = createURLListParser();
    }
    else {
      fileParser = createSimpleURLParser();
    }
    return fileParser.createParameter(parser, commandLinePattern, group,
      configurator);
  }

  /**
   * Cria o parser de parmetro para arquivo simples.
   * 
   * @return o parser.
   */
  protected abstract AbstractURLParameterParser<?> createURLListParser();

  /**
   * Cria o parser de parmetro do tipo URL.
   * 
   * @return parser.
   */
  protected abstract AbstractURLParameterParser<?> createSimpleURLParser();
}
