/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

import java.util.Hashtable;
import java.util.Map;

import tecgraf.javautils.xml.XMLElementFactory;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLEmptyElement;
import tecgraf.javautils.xml.XMLNullDataElement;
import csbase.logic.algorithms.AlgorithmsPack;

/**
 * Esta classe implementa a fbrica de elementos XML para o pacote de
 * algoritmos.
 * 
 * Ela permite associar objetos da aplicao com a tag raiz do documento que
 * ser persistido. Permite tambm associar as tags XML com as respectivas
 * classes dos seus elementos, necessrias tanto para leitura quanto para
 * escrita.
 * 
 */
public class XmlAlgorithmsPackFactory extends XMLElementFactory {
  /** Tabela de mapeamento - usada pelo Writer */
  private Hashtable<String, Class<? extends XMLElementInterface>> tagToXMLMap;

  /** Tabela de mapeamento - usada pelo Writer */
  private Hashtable<Class<?>, String> appObjectToTagMap;

  /** Objeto da aplicao associado ao contexto de leitura */
  private Object appContextObject;

  /**
   * Constri a fbrica de elementos para uma lista de algoritmos.
   * 
   * @param algorithmsPack pacote de algoritmos
   */
  public XmlAlgorithmsPackFactory(AlgorithmsPack algorithmsPack) {
    setAppContextObject(algorithmsPack);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setAppContextObject(Object contextApplication) {
    this.appContextObject = contextApplication;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getAppContextObject() {
    return this.appContextObject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void fillConversionTables() {
    if (tagToXMLMap == null) {
      tagToXMLMap =
        new Hashtable<String, Class<? extends XMLElementInterface>>();
    }
    if (appObjectToTagMap == null) {
      appObjectToTagMap = new Hashtable<Class<?>, String>();
    }
    //TODO ANDREA Terminar de fazer o mapeamento de todas as tags do xml
    mapAppClassToTag(AlgorithmsPack.class,
      XmlAlgorithmsPackUtils.ALGORITHMS_TAG);

    // Associao das tags com as classes XML
    mapTagToXMLClass(XmlAlgorithmsPackUtils.ALGORITHMS_TAG,
      XmlAlgorithmsPackElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.ALGORITHM_TAG,
      XmlAlgorithmElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.ALGORITHM_ID_TAG,
      XMLNullDataElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.ALGORITHM_NAME_TAG,
      XMLNullDataElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.DESCRIPTION_TAG,
      XMLNullDataElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.PROPERTIES_TAG,
      XMLPropertySetElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.PROPERTY_TAG, XMLEmptyElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.VERSIONS_TAG,
      XMLVersionSetElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.VERSION_TAG,
      XMLVersionElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.CATEGORIES_TAG,
      XMLCategorySetElement.class);
    mapTagToXMLClass(XmlAlgorithmsPackUtils.CATEGORY_TAG, XMLEmptyElement.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, Class<? extends XMLElementInterface>> getTagToXMLMap() {
    return this.tagToXMLMap;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<Class<?>, String> getAppObjectToTagMap() {
    return this.appObjectToTagMap;
  }
}
