package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * Dados bsicos do servidor.
 * 
 * @author Tecgraf
 */
public class ServerBasicInfo implements Serializable {
  /** O nome do sistema */
  public final String systemName;
  /** A verso do sistema */
  public final String systemVersion;
  /** A data/hora de startup do servidor */
  public final long startUpTime;
  /** O sistema operacional da mquina do servidor */
  public final String operationalSystem;
  /** O nome da mquina do servidor */
  public final String hostName;
  /** O IP da mquina do servidor */
  public final String hostIP;
  /** O charset do servidor */
  public final String charset;
  /** Verso de Java no servidor */
  public final String javaVersion;
  /** Argumentos para a linha de comando */
  public final String javaArgs;
  /** Porta RMI */
  public final int rmiPort;
  /** Libs carregadas na JVM */
  public final String[] serverLibs;
  /** Path para o repositrio de projetos */
  public final String projectDir;
  /** Path para o repositrio de algorithmos */
  public final String algorithmDir;
  /** Path para o repositrio de persistncia */
  public final String persistencyDir;
  /** Path para o diretrio de execuo do servidor */
  public final String serverRunningDir;

  /**
   * Construtor.
   * 
   * @param systemName o nome do sistema
   * @param systemVersion a verso do sistema
   * @param startUpTime a data/hora de inicializao do servidor
   * @param operationalSystem o sistema operacional da mquina do servidor
   * @param hostName o nome da mquina do servidor
   * @param hostIP o IP da mquina do servidor
   * @param charset o charset do servidor
   * @param javaVersion verso de Java no servidor
   * @param javaArgs argumentos para a linha de comando
   * @param rmiPort porta RMI
   * @param serverLibs bibliotecas carregadas na JVM do servidor
   * @param projectDir path para o repositrio de projetos
   * @param algorithmDir path para o repositrio de algorithmos
   * @param persistencyDir path para o repositrio de persistncia
   * @param serverRunningDir path para o diretrio de execuo do servidor
   */
  public ServerBasicInfo(String systemName, String systemVersion,
    long startUpTime, String operationalSystem, String hostName, String hostIP,
    String charset, String javaVersion, String javaArgs, int rmiPort,
    String[] serverLibs, String projectDir, String algorithmDir,
    String persistencyDir, String serverRunningDir) {
    this.systemName = systemName;
    this.systemVersion = systemVersion;
    this.startUpTime = startUpTime;
    this.operationalSystem = operationalSystem;
    this.hostName = hostName;
    this.hostIP = hostIP;
    this.charset = charset;
    this.javaVersion = javaVersion;
    this.javaArgs = javaArgs;
    this.rmiPort = rmiPort;
    this.serverLibs = serverLibs;
    this.projectDir = projectDir;
    this.algorithmDir = algorithmDir;
    this.persistencyDir = persistencyDir;
    this.serverRunningDir = serverRunningDir;
  }
}
