package csbase.logic.algorithms.parameters;

/**
 * Observador do Parmetro Tipo Tabela.
 * 
 * @author lmoreira
 */
public interface TableParameterListener {
  /**
   * Indica que uma linha foi criada.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param rowValue O valor da linha (Aceita {@code null}).
   * @param rowIndex O ndice da linha (No-negativo).
   */
  public void rowWasCreated(TableParameter parameter, RowValue rowValue,
    int rowIndex);

  /**
   * Indica que uma linha foi removida.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param rowValue O valor da linha (Aceita {@code null}).
   * @param rowIndex O ndice da linha (No-negativo).
   */
  public void rowWasRemoved(TableParameter parameter, RowValue rowValue,
    int rowIndex);
}
