package csbase.logic.algorithms.parsers.elements;

import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_LABEL_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE;

import java.util.List;
import java.util.Map;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;

/**
 * Parmetro simples lido pelo parser.
 */
public class ParsedSimpleParameter extends ParsedParameter {

  /**
   * O rtulo do parmetro.
   */
  private final String label;
  /**
   * A descrio do parmetro.
   */
  private final String description;
  /**
   * Indica se o parmetro  opcional.
   */
  private final boolean isOptional;
  /**
   * Indica se o parmetro  visvel.
   */
  private final boolean isVisible;
  /**
   * Indica se o parmetro deve ser ignorado se estiver invisvel.
   */
  private final boolean ignoreIfInvisible;
  /**
   * Indica se o parmetro deve ser ignorado se estiver desabilitado.
   */
  private final boolean ignoreIfDisabled;

  /**
   * Construtor.
   *
   * @param attributeValues mapa de valores dos atributos.
   * @param children lista de elementos-filhos.
   * @param defaultCommandLinePattern valor padro da linha de comando.
   * @throws ParseException em caso de erro.
   */
  public ParsedSimpleParameter(Map<IElementAttribute<?>, Object> attributeValues,
    Map<IElementStructure<?>, List<ParsedElement>> children,
    String defaultCommandLinePattern) throws ParseException {
    super(attributeValues, children, defaultCommandLinePattern);
    this.label = getAttributeValue(PARAMETER_ELEMENT_LABEL_ATTRIBUTE);
    this.description =
      getAttributeValue(PARAMETER_ELEMENT_DESCRIPTION_ATTRIBUTE);
    this.ignoreIfInvisible =
      getAttributeValue(PARAMETER_ELEMENT_IGNORE_IF_INVISIBLE_ATTRIBUTE);
    this.ignoreIfDisabled =
      getAttributeValue(PARAMETER_ELEMENT_IGNORE_IF_DISABLED_ATTRIBUTE);
    this.isOptional = getAttributeValue(PARAMETER_ELEMENT_OPTIONAL_ATTRIBUTE);
    boolean isHidden = getAttributeValue(PARAMETER_ELEMENT_HIDDEN_ATTRIBUTE);
    this.isVisible = !isHidden;
  }

  public void checkValues() throws ParseException {
    for (IElementAttribute<?> elementAttribute : getAttributes()) {
      elementAttribute.validate(this);
    }
  }

  /**
   * Obtm o rtulo do parmetro.
   *
   * @return o rtulo.
   */
  public String getLabel() {
    return label;
  }

  /**
   * Obtm a descrio do parmetro.
   *
   * @return a descrio.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Indica se o parmetro  opcional.
   *
   * @return verdadeiro se o parmetro for opcional ou falso, caso contrrio.
   */
  public boolean isOptional() {
    return isOptional;
  }

  /**
   * Indica se o parmetro  visvel.
   *
   * @return verdadeiro se o parmetro for visvel ou falso, caso contrrio.
   */
  public boolean isVisible() {
    return isVisible;
  }

  /**
   * Indica se o parmetro deve ser ignorado se estiver invisvel.
   *
   * @return verdadeiro se o parmetro deve ser ignorado ou falso, caso
   * contrrio.
   */
  public boolean isIgnoreIfInvisible() {
    return ignoreIfInvisible;
  }

  /**
   * Indica se o parmetro deve ser ignorado se estiver desabilitado.
   *
   * @return verdadeiro se o parmetro deve ser ignorado ou falso, caso
   * contrrio.
   */
  public boolean isIgnoreIfDisabled() {
    return ignoreIfDisabled;
  }

}
