package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.InputFileParameterParser
  .INPUT_FILE_PARAMETER_ELEMENT;

import java.util.ArrayList;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.FileElementPipeAcceptanceAttribute;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;

/**
 * <p>
 * Analisador de {@link InputFileListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "arquivo de entrada"
 * mltiplo. O elemento corrente do {@link XmlParser analisador de XML} precisa
 * ser um elemento {@link InputFileListParameter}.
 * </p>
 */
class InputFileListParameterParser extends
  AbstractFileParameterParser<InputFileListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  public InputFileListParameter createFileParameter(
    ParsedSimpleParameter definition, String[] types,
    FileParameterMode mode) throws ParseException {

    //TODO BELLA: No seria melhor no declarar o parmetro como aceito?
    final FileParameterPipeAcceptance usesPipe = definition
      .getAttributeValue(FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE);
    if (usesPipe == FileParameterPipeAcceptance.TRUE || usesPipe ==
      FileParameterPipeAcceptance.ALWAYS) {
      throw new ParseException(
        "Arquivo de entrada (seleo mltipla) no admite pipes");
    }

    boolean useRootDirectoryAsDefault = definition.getAttributeValue(
      FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE);
    List<FileURLValue> defaultValue = null;
    if (useRootDirectoryAsDefault) {
      if (mode == FileParameterMode.REGULAR_FILE) {
        throw new ParseException(
          "O atributo {0}  invlido quando o parmetro de entrada  um " +
            "arquivo.",
          FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE);
      }
      defaultValue = new ArrayList<>();
      defaultValue.add(new FileURLValue(".", ProjectFileType.DIRECTORY_TYPE));
    }

    boolean mustSort =
      definition.getAttributeValue(FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE);

    boolean useFilter =
      definition.getAttributeValue(FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE);

    InputFileListParameter parameter =
      new InputFileListParameter(definition.getName(), definition.getLabel(),
        definition.getDescription(), defaultValue, definition.isOptional(),
        definition.isVisible(), definition.getCommandLinePattern(), types, mode,
        mustSort, useFilter);
    return parameter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<InputFileListParameter> getParameterStructure() {
    ParameterStructure<InputFileListParameter> fileStructure =
      getFileStructure(INPUT_FILE_PARAMETER_ELEMENT,
        InputFileListParameter.class);
    fileStructure.addAttribute(new FileElementPipeAcceptanceAttribute(
      FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE,
      FileParameterPipeAcceptance.FALSE));
    fileStructure.addAttribute(new BooleanAttribute(
      FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE,
      FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_DEFAULT_VALUE));
    fileStructure.addAttribute(
      new BooleanAttribute(FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_MUST_SORT_DEFAULT_VALUE));
    fileStructure.addAttribute(
      new BooleanAttribute(FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_USE_FILTER_DEFAULT_VALUE));
    return fileStructure;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean acceptBothCategory() {
    return true;
  }
}
