package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.elements.SimpleParameterStructure.PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;

/**
 * <p>
 * Carrega um {@link IntegerParameter}.
 * </p>
 *
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link IntegerParameter}.
 * </p>
 */
public class IntegerParameterFactory extends
  SimpleParameterParser<IntegerParameter> implements
  IntegerStructureAttributes {

  /**
   * <p>
   * O elemento {@value #INTEGER_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link IntegerParameter parmetro do tipo inteiro}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String INTEGER_PARAMETER_ELEMENT = "inteiro";

  /**
   * {@inheritDoc}
   */
  @Override
  public IntegerParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Integer maximum = definition.getAttributeValue(
      INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE);
    Integer minimum = definition.getAttributeValue(
      INTEGER_ELEMENT_MINIMUM_ATTRIBUTE);
    IntegerAttribute attribute = (IntegerAttribute) definition.getAttribute(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    attribute.setMaximumValue(maximum);
    attribute.setMinimumValue(minimum);
    Integer defaultValue = definition.getAttributeValue(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    //TODO BELLA: Tentar remover
    definition.checkValues();
    IntegerParameter parameter = new IntegerParameter(definition.getName(),
      definition.getLabel(), definition.getDescription(), defaultValue,
      definition.isOptional(), definition.isVisible(), definition
        .getCommandLinePattern(), maximum, minimum);
    return parameter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<IntegerParameter> getParameterStructure() {
    ParameterStructure<IntegerParameter> integerStructure = getIntegerStructure(
      INTEGER_PARAMETER_ELEMENT, IntegerParameter.class);
    integerStructure.addAttribute(new IntegerAttribute(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null));
    return integerStructure;
  }

}
