/*
 * $Id: XMLConversionServiceInterface.java 179597 2017-04-10 21:33:25Z cviana $
 */
package csbase.remote;

import java.rmi.RemoteException;

import tecgraf.javautils.xml.conversion.XMLConverter;
import tecgraf.javautils.xml.conversion.XMLConverter.XMLConversionStatus;

/**
 * Interface para o servio de converso de arquivos XML para compatibiliz-los
 * com a ltima verso do DTD.
 */
public interface XMLConversionServiceInterface extends ServiceInterface {

  /**
   * Nome do servio.
   */
  String SERVICE_NAME = "XMLConversionService";

  /**
   * Converte um arquivo XML para a ltima verso. O contedo do arquivo
   * original  sobrescrito com os dados convertidos.
   * 
   * @param projectId - identificador do projeto
   * @param clientPath - path relativo para o arquivo no projeto
   * @param validate - flag indicando se o contedo deve ser validado pelo DTD
   *        correspondente
   * @param dtdPrefix - string que ser prefixada na declarao do DTD. Pode ser
   *        <code>null</code> caso no se deseje um prefixo especfico
   * @param clazz a classe do conversor a ser utilizada
   * @return status da converso
   * @throws RemoteException caso haja qualquer problema durante a converso
   */
  public XMLConversionStatus convertXMLToFile(Object projectId,
    String[] clientPath, boolean validate, String dtdPrefix,
    Class<? extends XMLConverter> clazz) throws RemoteException;

  /**
   * Converte um arquivo XML para a ltima verso. O contedo XML do arquivo 
   * convertido, e o resultado  retornado em uma string.
   * 
   * @param projectId - identificador do projeto
   * @param clientPath - path relativo para o arquivo no projeto
   * @param validate - flag indicando se o contedo deve ser validado pelo DTD
   *        correspondente
   * @param dtdPrefix - string que ser prefixada na declarao do DTD. Pode ser
   *        <code>null</code> caso no se deseje um prefixo especfico
   * @param clazz a classe do conversor a ser utilizada
   * @return XML convertido para a ltima verso, ou <code>null</code> em caso
   *         de erro
   * @throws RemoteException caso haja qualquer problema durante a converso
   */
  public String convertXMLToString(Object projectId, String[] clientPath,
    boolean validate, String dtdPrefix, Class<? extends XMLConverter> clazz)
      throws RemoteException;
}
