/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import java.io.Serializable;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public abstract class Trigger<P extends Parameter<?>>
implements Serializable {
    private Condition condition;
    private P parameter;

    protected Trigger(P parameter, Condition condition) {
        this.setParameter(parameter);
        this.setCondition(condition);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Trigger trigger = (Trigger)obj;
        return ((Parameter)this.getParameter()).equals(trigger.getParameter());
    }

    public int hashCode() {
        return ((Parameter)this.getParameter()).hashCode();
    }

    public String toString() {
        String toString = "Classe = " + this.getClass().getName() + "\n";
        toString = toString + "Parametro = " + ((Parameter)this.getParameter()).getName() + "\n";
        toString = toString + "Condi\u00e7\u00e3o = " + this.getCondition() + "\n";
        return toString;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public P getParameter() {
        return this.parameter;
    }

    public final boolean update(SimpleAlgorithmConfigurator configurator) {
        if (!this.condition.evaluate(configurator)) {
            this.undoAction();
            return false;
        }
        this.doAction();
        return true;
    }

    protected abstract void doAction();

    protected abstract void undoAction();

    private void setCondition(Condition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "condition"));
        }
        this.condition = condition;
    }

    private void setParameter(P parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameter"));
        }
        this.parameter = parameter;
    }
}

