/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.MultipleParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class FileParameterFactory
implements MultipleParameterFactory {
    public static final String FILE_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE = "selecao_multipla";
    public static final boolean FILE_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE = false;

    @Override
    public Parameter<?> createParameter(XmlParser parser, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean isMultipleSelection = parser.getAttributeValueAsBoolean(FILE_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE, false);
        AbstractFileParameterParser<?> fileParser = null;
        fileParser = isMultipleSelection ? this.createFileListParser() : this.createSimpleFileParser();
        return fileParser.createParameter(parser, commandLinePattern, group, configurator);
    }

    protected abstract AbstractFileParameterParser<?> createFileListParser();

    protected abstract AbstractFileParameterParser<?> createSimpleFileParser();
}

