/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.util.Hashtable;
import java.util.Map;

public class CommandInfoCache {
    private static CommandInfoCache instance;
    private Map<String, CommandInfo> cache = new Hashtable<String, CommandInfo>();
    private static boolean isEnable;

    private CommandInfoCache() {
    }

    public static CommandInfoCache getInstance() {
        if (instance == null) {
            instance = new CommandInfoCache();
        }
        return instance;
    }

    public static void enable() {
        isEnable = true;
    }

    public synchronized CommandInfo getCommandInfo(CommandInfo info) {
        if (!isEnable) {
            return info;
        }
        if (!this.cache.containsKey(info.getId())) {
            this.cache.put(info.getId(), info);
        } else if (!info.getStatus().equals((Object)CommandStatus.SCHEDULED)) {
            this.cache.get(info.getId()).setStatus(info.getStatus());
        }
        return this.cache.get(info.getId());
    }

    static {
        isEnable = false;
    }
}

