/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.AbstractEnumerationParameterParser;
import csbase.logic.algorithms.parsers.EnumerationListParameterParser;
import csbase.logic.algorithms.parsers.EnumerationParameterParser;
import csbase.logic.algorithms.parsers.MultipleParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import java.util.ArrayList;
import java.util.List;

public class EnumerationParameterFactory
implements MultipleParameterFactory {
    public static final String ENUMERATION_PARAMETER_ELEMENT = "enumeracao";
    protected static final String ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE = "selecao_multipla";
    protected static final boolean ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE = false;
    private EnumerationListParameterParser enumListParser;
    private EnumerationParameterParser enumParser = new EnumerationParameterParser();

    public EnumerationParameterFactory() {
        this.enumListParser = new EnumerationListParameterParser();
    }

    @Override
    public Parameter<?> createParameter(XmlParser parser, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean isMultipleSelection = parser.getAttributeValueAsBoolean(ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE, false);
        AbstractEnumerationParameterParser enumerationParser = isMultipleSelection ? this.enumListParser : this.enumParser;
        return enumerationParser.createParameter(parser, commandLinePattern, group, configurator);
    }

    @Override
    public List<ParameterStructure<?>> getParameterStructures() {
        ArrayList types = new ArrayList();
        types.add(this.getSimpleStructure());
        types.add(this.getMultipleStructure());
        return types;
    }

    @Override
    public BooleanAttribute getAttribute() {
        return new BooleanAttribute(ENUMERATION_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE, false);
    }

    @Override
    public ParameterStructure<?> getParameterStructure(boolean value) {
        if (value) {
            return this.getMultipleStructure();
        }
        return this.getSimpleStructure();
    }

    private ParameterStructure<?> getSimpleStructure() {
        ParameterStructure<EnumerationParameter> structure = this.enumParser.getParameterStructure();
        structure.addAttribute(this.getAttribute());
        return structure;
    }

    private ParameterStructure<?> getMultipleStructure() {
        ParameterStructure<EnumerationListParameter> structure = this.enumListParser.getParameterStructure();
        structure.addAttribute(this.getAttribute());
        return structure;
    }
}

