/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import tecgraf.javautils.core.lng.LNG;

public final class DoubleColumn
extends BasicColumn<Double> {
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;

    public DoubleColumn(String id, String label, Double defaultValue, boolean isOptional, boolean isEditable, Double maximum, boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded) {
        super(id, label, defaultValue, isOptional, isEditable);
        this.setMaximum(maximum, isMaximumIncluded);
        this.setMinimum(minimum, isMinimumIncluded);
    }

    @Override
    public Double getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            double doubleValue = Double.parseDouble(itemValue);
            return new Double(doubleValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidDouble"), itemValue, this);
        }
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    @Override
    public SimpleParameterValidator<Double> getValidator() {
        return new DoubleParameterValidator(this.isOptional(), this.getMaximum(), this.isMaximumIncluded(), this.getMinimum(), this.isMinimumIncluded());
    }

    private void setMaximum(Double maximum, boolean isMaximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        this.isMaximumIncluded = maximum == null ? false : isMaximumIncluded;
        this.maximum = maximum;
    }

    private void setMinimum(Double minimum, boolean isMinimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        this.isMinimumIncluded = minimum == null ? false : isMinimumIncluded;
        this.minimum = minimum;
    }
}

