/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.User;
import java.io.Serializable;
import java.util.Date;

public class SharedObject
implements Serializable {
    private Object id;
    private String category;
    private Object ownerUserId;
    private String name;
    private Object[] usersRO;
    private Object[] usersRW;
    private Date created;
    private Date lastModified;
    private Object contents;
    private boolean global;

    public SharedObject(String category, Object ownerUserId, String name, boolean global, Object contents) {
        this(category, ownerUserId, name, global, new Object[0], new Object[0], contents);
    }

    public SharedObject(String category, Object ownerUserId, String name, Object[] usersRO, Object contents) {
        this(category, ownerUserId, name, false, usersRO, new Object[0], contents);
    }

    public SharedObject(String category, Object ownerUserId, String name, boolean global, Object[] usersRO, Object[] usersRW, Object contents) {
        this.category = category;
        this.ownerUserId = ownerUserId;
        this.name = name;
        this.global = global;
        this.usersRO = usersRO;
        this.usersRW = usersRW;
        this.contents = contents;
        this.id = SharedObject.getId(ownerUserId, name);
    }

    public Object getId() {
        return this.id;
    }

    public Object[] getUsersRO() {
        return this.usersRO;
    }

    public void setUsersRO(Object[] usersRO) {
        this.usersRO = usersRO;
    }

    public Object[] getUsersRW() {
        return this.usersRW;
    }

    public void setUsersRW(Object[] usersRW) {
        this.usersRW = usersRW;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Object getContents() {
        return this.contents;
    }

    public void setContents(Object contents) {
        this.contents = contents;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isShared() {
        return this.isGlobal() || this.usersRO != null && this.usersRO.length > 0 || this.usersRW != null && this.usersRW.length > 0;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(Object ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public boolean userHasAccessRW(Object userId) {
        boolean userCanWrite = false;
        if (this.getOwnerUserId().equals(userId) || userId.equals(User.getAdminId())) {
            userCanWrite = true;
        } else {
            Object[] usersRW;
            for (Object currUserId : usersRW = this.getUsersRW()) {
                if (!currUserId.equals(userId)) continue;
                userCanWrite = true;
                break;
            }
        }
        return userCanWrite;
    }

    public Object[] getAllUsers() {
        Object[] usersId = new Object[this.usersRO.length + this.usersRW.length];
        System.arraycopy(this.usersRO, 0, usersId, 0, this.usersRO.length);
        System.arraycopy(this.usersRW, 0, usersId, this.usersRO.length, this.usersRW.length);
        return usersId;
    }

    public static Object getId(Object userId, String name) {
        return userId + "/" + name;
    }

    public static Object getUserId(Object id) {
        return ((String)id).split("/")[0];
    }

    public static String getName(Object id) {
        return ((String)id).split("/")[1];
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SharedObject shared = (SharedObject)other;
        return (this.category == shared.category || this.category != null && this.category.equals(shared.category)) && (this.ownerUserId == shared.ownerUserId || this.ownerUserId != null && this.ownerUserId.equals(shared.ownerUserId)) && (this.name == shared.name || this.name != null && this.name.equals(shared.name));
    }

    public String toString() {
        return this.name;
    }
}

