/*
 * CommandKilledNotificationData.java
 * 
 * $Author: cassino $ $Date: 2011-03-04 15:15:45 -0300 (Fri, 04 Mar 2011) $
 * $Revision: 116055 $
 */

package csbase.logic;

/**
 * Classe que representa os dados de mensagem de comando interrompido em um SGA.
 * Essa interrupo foi gerada pelo usurio, via "Cancelar Comando" da interface
 * de "Monitorao de Execuo de Comandos".
 */
public class CommandKilledNotification extends
  DefaultCommandFinishedNotification {

  /**
   * Constri o evento de trmino de comando sem dados de tempo.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param startTime Hora de incio
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public CommandKilledNotification(String sender, Object commandId,
    String cmdDesc, String tip, long startTime, String execHost,
    Object projectId, CommandFinalizationInfo finalizationInfo) {
    super(sender, commandId, cmdDesc, tip, startTime, execHost, projectId,
      finalizationInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getStatusString() {
    return "KILLED";
  }
}
