/*
 * $Id: FileSystemSpaceNotification.java 116313 2011-03-17 21:57:13Z clinio $
 */

package csbase.logic;

/**
 * Notificao de espao em disco utilizado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileSystemSpaceNotification extends Notification {

  /**
   * Nome do file system.
   */
  final private String fileSystemId;

  /**
   * Percentual
   */
  final private double percentage;

  /**
   * Indicativo de volatilidade;
   */
  final private boolean isVolatile;

  /**
   * A escala comparativa.
   */
  final private int scale;

  /**
   * Consulta o valor do nome do file system
   * 
   * @return o valor
   */
  public final String getFileSystemId() {
    return fileSystemId;
  }

  /**
   * Consulta o valor de scale
   * 
   * @return o valor
   */
  public final int getScale() {
    return scale;
  }

  /**
   * Consulta o valor do percentual
   * 
   * @return o valor
   */
  public final double getPercentage() {
    return percentage;
  }

  /**
   * {@inheritDoc}
   * 
   * A volatilidade  dada na construo da mensagem; isto , quem notifica
   * determina se a mensagem ser ou no voltil.
   */
  @Override
  public boolean isVolatile() {
    return isVolatile;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    final String prefix = "Aviso de espao no file system ";
    final String perc = String.format("%.2f%%", percentage);
    return prefix + fileSystemId + " em: " + perc;
  }

  /**
   * Construtor
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param fileSystemId nome do file system
   * @param percentage percentual infomado
   * @param scale a escala de aviso.
   * @param isVolatile volatilidade da mensagem
   */
  public FileSystemSpaceNotification(String sender, String fileSystemId,
    double percentage, int scale, boolean isVolatile) {
    super(sender);
    this.fileSystemId = fileSystemId;
    this.percentage = percentage;
    this.isVolatile = isVolatile;
    this.scale = scale;
  }
}
