/*
 * $Id$
 */

package csbase.logic;

import java.io.File;
import java.io.Serializable;

/**
 * @author Tecgraf / PUC-Rio
 * 
 * Representa uma fbrica utilizada para gerar um caminho absoluto a partir de
 * um caminho relativo representado por um {@link FileInfo} e seus ancestrais.
 */
public interface IPathFactory extends Serializable {

  /**
   * Fbrica de caminho padro que percorre os ancestrais de um arquivo, do mais
   * velho ao mais novo, separando-os por {@link File#separator} at chegar no
   * arquivo corrente. Ex.: dir1/dir2/dir3/ ou dir1/dir2/dir3/file.
   */
  public final IPathFactory DEFAULT = new IPathFactory() {
    @Override
    public String getPath(FileInfo fileInfo) {
      String[] path = fileInfo.getPathAsArray();
      StringBuilder pathBuilder = new StringBuilder();
      for (int inx = 0; inx < path.length; inx++) {
        if (0 < inx) {
          pathBuilder.append(File.separator);
        }
        pathBuilder.append(path[inx]);
      }
      if (fileInfo.isDirectory()) {
        pathBuilder.append(File.separator);
      }

      return pathBuilder.toString();
    }
  };

  /**
   * Obtm um caminho absoluto a um arquivo, a partir de um relativo
   * representado por um {@link FileInfo}.
   * 
   * @param fileInfo representao de um caminho relativo.
   * 
   * @return um caminho absoluto a um arquivo, a partir de um relativo
   *         representado por um {@link FileInfo}.
   */
  String getPath(FileInfo fileInfo);
}
