/*
 * $Id$
 */

package csbase.logic.algorithms;

import java.io.Serializable;

import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;

public class ExecutablePathFactory implements IPathFactory, Serializable {

  private AlgorithmVersionInfo version;
  private String platform;

  public ExecutablePathFactory(AlgorithmVersionInfo version, String platform) {
    this.version = version;
    this.platform = platform;
  }

  @Override
  public String getPath(FileInfo fileInfo) {
    return version.getExecFilePath(platform, fileInfo.getPath());
  }
}