package csbase.logic.algorithms;

import java.io.Serializable;
import java.util.Date;

/**
 * Classe que representa uma operao em um diretrio registrada em histrico.
 *
 * @author Leonardo Barros
 */
public class HistoryRecord implements Serializable {
  /** ndice da coluna Data */
  public static final int DATE_COLUMN_INDEX = 0;
  /** ndice da coluna Caminho */
  public static final int PATH_COLUMN_INDEX = 1;
  /** ndice da coluna Login */
  public static final int LOGIN_COLUMN_INDEX = 2;
  /** ndice da coluna Nome */
  public static final int NAME_COLUMN_INDEX = 3;
  /** ndice da coluna Descrio */
  public static final int DESCRIPTION_COLUMN_INDEX = 4;  
  
  /** Data de registro da operao */
  private Date date;
  /** Caminho para o diretrio no qual a operao ocorreu */
  private String[] dirPath;
  /** Login do usurio que executou a operao */
  private String userLogin;
  /** Nome do usurio que executou a operao */
  private String userName;
  /** Descrio da operao executada */
  private String description;
  
  /**
   * Cria um registro de histrico.
   * 
   * @param date data de registro de operao.
   * @param dirPath caminho para o diretrio no qual a operao ocorreu.
   *  @param userLogin login do usurio que executou a operao.
   * @param userName nome do usurio que executou a operao.
   * @param description descrio da operao executada.
   */
  public HistoryRecord(
    Date date, String[] dirPath, String userLogin, String userName, 
    String description) {
    this.date = date;
    this.dirPath = dirPath;
    this.userLogin = userLogin;
    this.userName = userName;
    this.description = description;
  }
  
  /**
   * Obtm  a data de registro da operao.
   * 
   * @return data de registro da operao.
   */
  public Date getDate() {
    return date;
  }
  
  /**
   * Obtm a descrio da operao executada.
   * 
   * @return descrio da operao executada.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Obtm o caminho para o diretrio no qual a operao ocorreu.
   * 
   * @return caminho para o diretrio no qual a operao ocorreu.
   */
  public String[] getDirPath() {
    return dirPath;
  }
  
  /**
   * Obtm o login do usurio que executou a operao.
   * 
   * @return login do usurio que executou a operao.
   */
  public String getUserLogin() {
    return userLogin;
  }
  
  /**
   * Obtm o nome do usurio que executou a operao.
   * 
   * @return nome do usurio que executou a operao.
   */
  public String getUserName() {
    return userName;
  }
  
}
