package csbase.logic.algorithms.parameters;

import java.util.EnumSet;
import java.util.List;

/**
 * Parametro que define uma lista de URLs de entrada.
 * 
 * @author Tecgraf
 */
public final class InputURLListParameter extends URLListParameter {

  /** Texto que representa o tipo desse parmetro */
  public static final String TYPE_VALUE = "INPUT_URL";

  /**
   * Cria um parmetro do tipo arquivo.
   * 
   * @param name O nome deste parmetro (No aceita {@code null}).
   * @param label O rtulo deste parmetro (No aceita {@code null}).
   * @param description A descrio deste parmetro (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se o valor do parmetro  opcional.
   * @param isVisible Indica se o parmetro deve ficar visvel.
   * @param commandLinePattern O padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param localization define o argumento na linha de comando informando o
   *        protoloco usado pelo usurio.
   * @param fileTypes Os tipos dos arquivos aceitos neste parmetro (Aceita
   *        {@code null}).
   * @param mode O modo de funcionamento deste parmetro (No aceita
   *        {@code null}).
   * @param mustSort Indica se os caminhos para os arquivos precisam ser
   *        ordenados.
   * @param allowedProtocols conjunto de protocolos aceitos na URL.
   */
  public InputURLListParameter(String name, String label, String description,
    List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String localization, String[] fileTypes,
    FileParameterMode mode, boolean mustSort,
    EnumSet<URLProtocol> allowedProtocols) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, localization, fileTypes, mode, mustSort, true,
      allowedProtocols);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getType() {
    return TYPE_VALUE;
  }

}
