package csbase.logic.algorithms.parameters;

import java.util.List;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import tecgraf.javautils.core.lng.LNG;

/**
 * Mtodo que determina o menor valor de uma lista.
 */
public final class ListMinExpressionFunction extends ListExpressionFunction {
  /**
   * Construtor.
   */
  public ListMinExpressionFunction() {
    super("list_min", new Class[] {});
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object doOperation(List<?> values, Object... arguments)
    throws ExpressionFunctionExecutionException {
    if (values == null) {
      throw new ExpressionFunctionExecutionException(LNG.get(
    		  "csbase.logic.algorithms.parameters.EmptyList"));
    }
    double minValue = Double.MAX_VALUE;
    for (Object value : values) {
      double doubleValue = Double.parseDouble(value.toString());
      if (doubleValue < minValue) {
        minValue = doubleValue;
      }
    }
    return minValue;
  }
}
