/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;

import java.io.Serializable;

/**
 * Observador de parmetros.
 *
 * @param <V> O tipo do valor armazenado no parmetro.
 * 
 * @author lmoreira
 */
public interface SimpleParameterListener<V> extends Serializable {
  /**
   * Indica que houve mudana no estado habilitado/desabilitado de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void capabilityWasChanged(SimpleParameter<V> parameter);

  /**
   * Indica que houve mudana no valor-padro de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void defaultValueWasChanged(SimpleParameter<V> parameter);

  /**
   * Indica que houve mudana no rtulo de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void labelWasChanged(SimpleParameter<V> parameter);
  
  /**
   * Indica que houve mudana no valor de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void valueWasChanged(SimpleParameter<V> parameter);

  /**
   * Indica que houve mudana no estado visvel/oculto de um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  public void visibilityWasChanged(SimpleParameter<V> parameter);
}
