package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * Condio sempre falsa.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class FalseCondition implements Condition {

  /**
   * A instncia nica (Singleton).
   */
  private static FalseCondition instance = new FalseCondition();

  /**
   * Cria a instncia.
   */
  private FalseCondition() {

  }

  /**
   * Obtm a instncia nica (Singleton).
   * 
   * @return .
   */
  public static FalseCondition getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean evaluate(SimpleAlgorithmConfigurator configurator) {
    return false;
  }

}
