package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * <p>
 * Gatilho Exibir Parmetro: Exibe o {@link SimpleParameter parmetro} quando a
 * {@link Condition condio} associada for aceita.
 * </p>
 * 
 * @author lmoreira
 */
public final class ShowParameterTrigger extends Trigger<SimpleParameter<?>> {
  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public ShowParameterTrigger(SimpleParameter<?> parameter,
    Condition condition) {
    super(parameter, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setVisible(false);
  }
}
