package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.Parameter;

/**
 * Fbrica de parmetros do tipo URL de entrada.
 * 
 * @author Tecgraf
 */
public class InputURLParameterFactory extends URLParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private InputURLListParameterParser inputURLListParser;

  /**
   * Parser do parmetro simples.
   */
  private InputURLParameterParser inputURLParser;

  /**
   * Construtor.
   */
  public InputURLParameterFactory() {
    inputURLParser = new InputURLParameterParser();
    inputURLListParser = new InputURLListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputURLParameterParser createSimpleURLParser() {
    return inputURLParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputURLListParameterParser createURLListParser() {
    return inputURLListParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    List<Class<? extends Parameter>> types = new ArrayList<>();
    types.addAll(inputURLParser.getParameterTypes());
    types.addAll(inputURLListParser.getParameterTypes());
    return types;
  }
}
