package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.Parameter;

/**
 * Fbrica de parmetros do tipo URL de sada.
 * 
 * @author Tecgraf
 */
public class OutputURLParameterFactory extends URLParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private final OutputURLListParameterParser outputURLListParameterParser;

  /**
   * Parser do parmetro simples.
   */
  private final OutputURLParameterParser outputURLParameterParser;

  /**
   * Construtor.
   */
  public OutputURLParameterFactory() {
    outputURLParameterParser = new OutputURLParameterParser();
    outputURLListParameterParser = new OutputURLListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected AbstractURLParameterParser<OutputURLParameter> createSimpleURLParser() {
    return outputURLParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputURLListParameterParser createURLListParser() {
    return outputURLListParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    List<Class<? extends Parameter>> types = new ArrayList<>();
    types.addAll(outputURLParameterParser.getParameterTypes());
    types.addAll(outputURLListParameterParser.getParameterTypes());
    return types;
  }
}
