package csbase.logic.algorithms.validation;

import csbase.logic.algorithms.flows.FlowNode;

/**
 * Resultado da validao de um n especfico do fluxo.
 */
public class FlowNodeValidationResult extends
  ElementValidationResult<FlowNode> {

  /**
   * Construtor que passa um n de fluxo como elemento. O resultado ser um
   * grupo.
   * 
   * @param node O n do fluxo que gerou o resultado.
   */
  public FlowNodeValidationResult(FlowNode node) {
    super(node);
  }

  /**
   * Construtor que incorpora outro resultado (copia) incluindo o n relativo ao
   * resultado.
   * 
   * @param validation O resultado da validao.
   * @param node O n do fluxo que gerou o resultado.
   */
  public FlowNodeValidationResult(final Validation validation,
    FlowNode node) {
    super(validation, node);
  }
}
