package csbase.logic.filters;

import csbase.logic.ProjectFileFilter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Define um filtro que  composto por vrios outros filtros.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public abstract class ProjectFileCompositeFilter implements ProjectFileFilter {
  /** Lista de ProjectFileFilter que fazem parte da composio. */
  private List filters;

  protected ProjectFileCompositeFilter() {
    this.filters = new LinkedList();
  }

  /**
   * Adiciona um filtro  composio.
   *
   * @param projectFileFilter O filtro a ser adicionado.
   *
   * @return true, se conseguiu adicionar o filtro na lista, ou false, caso
   *         contrrio.
   *
   * @throws IllegalArgumentException Caso o filtro recebido seja nulo.
   */
  public boolean addChild(ProjectFileFilter projectFileFilter) {
    if (projectFileFilter == null) {
      throw new IllegalArgumentException(
        "Mtodo addChild de ProjectFileCompositeFilter no aceita um filtro null.");
    }
    return this.filters.add(projectFileFilter);
  }

  /**
   * Remove um filtro da composio.
   *
   * @param projectFileFilter O filtro a ser removido.
   *
   * @return true, se conseguiu remover o filtro da composio, ou false, caso
   *         contrrio.
   */
  public boolean removeChild(ProjectFileFilter projectFileFilter) {
    return this.filters.remove(projectFileFilter);
  }

  /**
   * Retorna um iterador com os filtros da composio.
   *
   * @return O iterador com os filtros da composio.
   */
  protected final Iterator getFiltersIterator() {
    return this.filters.iterator();
  }
}
