package csbase.logic.filters;

import java.util.Iterator;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro composto que aceita arquivos que sejam aceitos por algum
 * dos filtros da composio.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ProjectFileCompositeOrFilter
extends ProjectFileCompositeFilter {
  public boolean accept(ClientProjectFile file) {
    Iterator filtersIterator = this.getFiltersIterator();
    while (filtersIterator.hasNext()) {
      ProjectFileFilter projectFileFilter =
        (ProjectFileFilter)filtersIterator.next();
      if (projectFileFilter.accept(file)) {
        return true;
      }
    }
    return false;
  }
}
